/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.MonitoringConfigurationContext;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.remote.agent.RemoteAgentLauncher;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.DirectoryUtils;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.IpUtils;

public class ClusterFactory
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterFactory.class);
    private static final String TSA = "tsa";
    private static final String TMS = "tms";
    private static final String CLIENT_ARRAY = "clientArray";
    private static final String MONITOR = "monitor";
    private static final DateTimeFormatter PATH_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-hhmmss");
    private final List<AutoCloseable> controllers = new ArrayList<AutoCloseable>();
    private final String idPrefix;
    private final AtomicInteger instanceIndex;
    private final Map<String, Collection<InstanceId>> nodeToInstanceId = new HashMap<String, Collection<InstanceId>>();
    private final ConfigurationContext configurationContext;
    private Ignite ignite;
    private Agent.Node localAgent;
    private transient RemoteAgentLauncher remoteAgentLauncher;
    private InstanceId monitorInstanceId;

    public ClusterFactory(String idPrefix, ConfigurationContext configurationContext) {
        this.idPrefix = idPrefix + "-" + LocalDateTime.now(ZoneId.of("UTC")).format(PATH_FORMAT);
        this.instanceIndex = new AtomicInteger();
        this.configurationContext = configurationContext;
        this.remoteAgentLauncher = configurationContext.remoting().buildRemoteAgentLauncher();
    }

    private InstanceId init(String type, Collection<String> targetServerNames) {
        if (targetServerNames.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize with 0 server");
        }
        boolean foundLocal = IpUtils.isAnyLocal(targetServerNames);
        boolean allLocal = IpUtils.areAllLocal(targetServerNames);
        if (foundLocal && !allLocal) {
            throw new IllegalArgumentException("Cannot mix local and non-local servers : " + targetServerNames);
        }
        if (!foundLocal && IpUtils.isAnyLocal(this.nodeToInstanceId.keySet())) {
            throw new IllegalArgumentException("local agent started, connection to remote agents '" + targetServerNames + "' is not possible");
        }
        if (foundLocal && (this.nodeToInstanceId.size() > 1 || this.nodeToInstanceId.size() == 1 && !IpUtils.isAnyLocal(this.nodeToInstanceId.keySet()))) {
            throw new IllegalArgumentException("remote agents '" + this.nodeToInstanceId.keySet() + "' already started, connecting to local is not possible");
        }
        InstanceId instanceId = new InstanceId(this.idPrefix + "-" + this.instanceIndex.getAndIncrement(), type);
        for (String targetServerName2 : targetServerNames) {
            if (targetServerName2 == null) {
                throw new IllegalArgumentException("Cannot initialize with a null server name");
            }
            if (!IpUtils.isLocal((String)targetServerName2)) {
                HashSet<String> nodesToJoin = new HashSet<String>();
                nodesToJoin.addAll(this.nodeToInstanceId.keySet());
                nodesToJoin.addAll(targetServerNames);
                LOGGER.info("Target server name: {} is not local. Using remoting agent for connection to: {}", (Object)targetServerName2, nodesToJoin);
                this.remoteAgentLauncher.remoteStartAgentOn(targetServerName2, nodesToJoin);
            }
            this.nodeToInstanceId.compute(targetServerName2, (s, instanceIds) -> {
                if (instanceIds == null) {
                    return Collections.singleton(instanceId);
                }
                ArrayList<InstanceId> list = new ArrayList<InstanceId>((Collection<InstanceId>)instanceIds);
                list.add(instanceId);
                return Collections.unmodifiableCollection(list);
            });
        }
        if (this.ignite == null) {
            if (allLocal) {
                LOGGER.info("spawning local agent");
                this.localAgent = new Agent.Node(targetServerNames.iterator().next(), Collections.emptyList());
            }
            TcpDiscoverySpi spi = new TcpDiscoverySpi();
            TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
            ipFinder.setAddresses((Collection)targetServerNames.stream().map(targetServerName -> new HostPort(targetServerName, 40000).getHostPort()).collect(Collectors.toList()));
            spi.setJoinTimeout(10000L);
            spi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
            IgniteConfiguration cfg = new IgniteConfiguration();
            cfg.setDiscoverySpi((DiscoverySpi)spi);
            cfg.setClientMode(true);
            DirectoryUtils.createAndValidateDir((Path)Agent.IGNITE_DIR);
            cfg.setIgniteHome(Agent.IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
            cfg.setPeerClassLoadingEnabled(true);
            boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
            cfg.setGridLogger((IgniteLogger)(enableLogging ? new Slf4jLogger() : new NullLogger()));
            cfg.setIgniteInstanceName("Instance@" + instanceId);
            cfg.setMetricsLogFrequency(0L);
            try {
                this.ignite = Ignition.start((IgniteConfiguration)cfg);
            }
            catch (IgniteException e) {
                throw new RuntimeException("Cannot start angela; error connecting to agents : " + targetServerNames, e);
            }
        }
        return instanceId;
    }

    public Cluster cluster() {
        if (this.ignite == null) {
            throw new IllegalStateException("No cluster component started");
        }
        return new Cluster(this.ignite);
    }

    public Tsa tsa() {
        TsaConfigurationContext tsaConfigurationContext = this.configurationContext.tsa();
        InstanceId instanceId = this.init(TSA, tsaConfigurationContext.getTopology().getServersHostnames());
        Tsa tsa = new Tsa(this.ignite, instanceId, tsaConfigurationContext);
        this.controllers.add(tsa);
        return tsa;
    }

    public Tms tms() {
        TmsConfigurationContext tmsConfigurationContext = this.configurationContext.tms();
        InstanceId instanceId = this.init(TMS, Collections.singletonList(tmsConfigurationContext.getHostname()));
        Tms tms = new Tms(this.ignite, instanceId, tmsConfigurationContext);
        this.controllers.add(tms);
        return tms;
    }

    public ClientArray clientArray() {
        ClientArrayConfigurationContext clientArrayConfigurationContext = this.configurationContext.clientArray();
        this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        ClientArray clientArray = new ClientArray(this.ignite, () -> this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames()), clientArrayConfigurationContext);
        this.controllers.add(clientArray);
        return clientArray;
    }

    public ClusterMonitor monitor() {
        MonitoringConfigurationContext monitoringConfigurationContext = this.configurationContext.monitoring();
        if (monitoringConfigurationContext == null) {
            throw new IllegalStateException("MonitoringConfigurationContext has not been registered");
        }
        Map<HardwareMetric, MonitoringCommand> commands = monitoringConfigurationContext.commands();
        Set<String> hostnames = this.configurationContext.allHostnames();
        if (this.monitorInstanceId == null) {
            this.monitorInstanceId = this.init(MONITOR, hostnames);
            ClusterMonitor clusterMonitor = new ClusterMonitor(this.ignite, this.monitorInstanceId, hostnames, commands);
            this.controllers.add(clusterMonitor);
            return clusterMonitor;
        }
        return new ClusterMonitor(this.ignite, this.monitorInstanceId, hostnames, commands);
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AutoCloseable controller : this.controllers) {
            try {
                controller.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        this.controllers.clear();
        if (this.ignite != null) {
            try {
                this.ignite.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            this.ignite = null;
        }
        this.nodeToInstanceId.clear();
        this.monitorInstanceId = null;
        try {
            this.remoteAgentLauncher.close();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        this.remoteAgentLauncher = null;
        if (this.localAgent != null) {
            try {
                LOGGER.info("shutting down local agent");
                this.localAgent.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            this.localAgent = null;
        }
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error while closing down Cluster Factory prefixed with " + this.idPrefix);
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }
}

