/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import io.restassured.path.json.JsonPath;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.tms.security.config.TmsClientSecurityConfig;

public class TmsHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmsHttpClient.class);
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String POST = "POST";
    private final String tmsBaseUrl;
    private final TmsClientSecurityConfig tmsClientSecurityConfig;
    private final Set<HttpCookie> cookies = new HashSet<HttpCookie>();
    private final Map<String, String> additionnalHeaders = new HashMap<String, String>();
    private static final String API_CONNECTIONS_PROBE_OLD = "/api/connections/probe/";
    private static final String API_CONNECTIONS_PROBE_NEW = "/api/connections/probe?uri=";
    private static final String APPLICATION_JSON = "application/json";

    TmsHttpClient(String tmsBaseUrl, TmsClientSecurityConfig tmsClientSecurityConfig) {
        this.tmsBaseUrl = Objects.requireNonNull(tmsBaseUrl);
        this.tmsClientSecurityConfig = tmsClientSecurityConfig;
    }

    public String createConnectionToCluster(URI uri) {
        String response;
        LOGGER.info("connecting TMS to {}", (Object)uri.toString());
        try {
            response = this.probeOldStyle(uri);
        }
        catch (FailedHttpRequestException e) {
            response = this.probeNewStyle(uri);
        }
        response = this.sendPostRequest("/api/connections", response);
        LOGGER.info("tms connect result :" + response);
        String connectionName = (String)JsonPath.from((String)response).get("config.connectionName");
        return connectionName;
    }

    private String probeOldStyle(URI uri) {
        return this.probe(uri, API_CONNECTIONS_PROBE_OLD);
    }

    private String probeNewStyle(URI uri) {
        return this.probe(uri, API_CONNECTIONS_PROBE_NEW);
    }

    private String probe(URI uri, String probeEndpoint) {
        try {
            String response = this.sendGetRequest(probeEndpoint + URLEncoder.encode(uri.toString(), String.valueOf(StandardCharsets.UTF_8)));
            LOGGER.info("tms probe result :" + response);
            return response;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode terracotta connection url", e);
        }
    }

    public void login() throws IOException, GeneralSecurityException {
        this.sendGetRequest("/login.html");
        String urlParameters = "username=" + this.tmsClientSecurityConfig.getUsername() + "&password=" + this.tmsClientSecurityConfig.getPassword();
        URL url = new URL(this.tmsBaseUrl + "/api/security/login");
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        HttpURLConnection connection = this.prepareHttpConnection(this.tmsClientSecurityConfig, url);
        connection.setRequestMethod(POST);
        connection.setInstanceFollowRedirects(false);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.write(postData);
        }
        this.saveHeaders(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 302) {
            throw new FailedHttpRequestException(responseCode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendGetRequest(String path) {
        try {
            HttpURLConnection connection = this.prepareHttpConnection(this.tmsClientSecurityConfig, new URL(this.tmsBaseUrl + path));
            this.saveHeaders(connection);
            TmsHttpClient.checkResponseCode(connection);
            try (InputStream inputStream = connection.getInputStream();){
                String string = IOUtils.toString((InputStream)inputStream);
                return string;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendPostRequest(String path, String payload) {
        try {
            HttpURLConnection connection = this.prepareHttpConnection(this.tmsClientSecurityConfig, new URL(this.tmsBaseUrl + path));
            TmsHttpClient.addHttpPostPayload(payload, connection);
            this.saveHeaders(connection);
            TmsHttpClient.checkResponseCode(connection);
            try (InputStream inputStream = connection.getInputStream();){
                String string = IOUtils.toString((InputStream)inputStream);
                return string;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpURLConnection prepareHttpConnection(TmsClientSecurityConfig tmsClientSecurityConfig, URL obj) throws IOException, GeneralSecurityException {
        HttpURLConnection connection;
        if (tmsClientSecurityConfig == null) {
            connection = (HttpURLConnection)obj.openConnection();
        } else {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmsClientSecurityConfig.getTrustManagerFactory().getTrustManagers(), null);
            connection = (HttpURLConnection)obj.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(context.getSocketFactory());
            }
        }
        if (this.additionnalHeaders.size() > 0) {
            this.additionnalHeaders.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
        }
        if (!this.cookies.isEmpty()) {
            connection.setRequestProperty("Cookie", StringUtils.join(this.cookies, (String)";"));
        }
        return connection;
    }

    private static void addHttpPostPayload(String payload, HttpURLConnection con) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", APPLICATION_JSON);
        headers.put("content-type", APPLICATION_JSON);
        con.setRequestMethod(POST);
        for (Map.Entry headersEntries : headers.entrySet()) {
            con.setRequestProperty((String)headersEntries.getKey(), (String)headersEntries.getValue());
        }
        con.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(payload);
        }
    }

    private static void checkResponseCode(HttpURLConnection con) throws IOException {
        int responseCode = con.getResponseCode();
        if (responseCode < 200 || responseCode > 299) {
            throw new FailedHttpRequestException(responseCode);
        }
    }

    private void saveHeaders(HttpURLConnection connection) {
        String cookiesHeader = connection.getHeaderField(SET_COOKIE);
        if (cookiesHeader != null) {
            List<HttpCookie> httpCookiesParsed = connection.getHeaderFields().entrySet().stream().filter(headers -> headers.getKey() != null).filter(headers -> ((String)headers.getKey()).equals(SET_COOKIE)).map(headers -> (List)headers.getValue()).flatMap(headerValues -> headerValues.stream()).map(header -> HttpCookie.parse(header)).flatMap(cookiesLists -> cookiesLists.stream()).collect(Collectors.toList());
            ArrayList cookiesToRemove = new ArrayList();
            httpCookiesParsed.forEach(cookieParsed -> this.cookies.stream().filter(cookie -> cookie.getName().equals(cookieParsed.getName())).forEach(cookiesToRemove::add));
            this.cookies.removeAll(cookiesToRemove);
            this.cookies.addAll(httpCookiesParsed);
        }
        this.cookies.stream().filter(httpCookie -> httpCookie.getName().equals("XSRF-TOKEN")).findFirst().ifPresent(xsrfTokenCookie -> this.additionnalHeaders.put("X-XSRF-TOKEN", xsrfTokenCookie.getValue()));
    }

    public static class FailedHttpRequestException
    extends RuntimeException {
        public FailedHttpRequestException(int responseCode) {
            super("The HTTP request failed with response code : " + responseCode);
        }
    }
}

