/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.Client;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;

public class Jcmd {
    private final TerracottaCommandLineEnvironment tcEnv;
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final TerracottaServer terracottaServer;
    private final Client client;

    Jcmd(Ignite ignite, InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv) {
        this.ignite = ignite;
        this.instanceId = instanceId;
        this.terracottaServer = terracottaServer;
        this.client = null;
        this.tcEnv = tcEnv;
    }

    Jcmd(Ignite ignite, InstanceId instanceId, Client client, TerracottaCommandLineEnvironment tcEnv) {
        this.ignite = ignite;
        this.instanceId = instanceId;
        this.terracottaServer = null;
        this.client = client;
        this.tcEnv = tcEnv;
    }

    public ToolExecutionResult executeCommand(String ... arguments) {
        IgniteCallable & Serializable callable;
        String hostname;
        if (this.terracottaServer != null) {
            hostname = this.terracottaServer.getHostname();
            callable = (IgniteCallable & Serializable)() -> Agent.controller.serverJcmd(this.instanceId, this.terracottaServer, this.tcEnv, arguments);
        } else if (this.client != null) {
            hostname = this.client.getHostname();
            callable = (IgniteCallable & Serializable)() -> Agent.controller.clientJcmd(this.instanceId, this.client.getPid(), this.tcEnv, arguments);
        } else {
            throw new AssertionError();
        }
        return (ToolExecutionResult)IgniteClientHelper.executeRemotely(this.ignite, hostname, callable);
    }
}

