/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.ClusterTool;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Jcmd;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.net.DisruptionController;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.DynamicConfigManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class Tsa
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Tsa.class);
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final transient DisruptionController disruptionController;
    private final TsaConfigurationContext tsaConfigurationContext;
    private final LocalKitManager localKitManager;
    private boolean closed = false;

    Tsa(Ignite ignite, InstanceId instanceId, TsaConfigurationContext tsaConfigurationContext) {
        this.tsaConfigurationContext = tsaConfigurationContext;
        this.instanceId = instanceId;
        this.ignite = ignite;
        this.disruptionController = new DisruptionController(ignite, instanceId, tsaConfigurationContext.getTopology());
        this.localKitManager = new LocalKitManager(tsaConfigurationContext.getTopology().getDistribution());
        this.installAll();
    }

    public TsaConfigurationContext getTsaConfigurationContext() {
        return this.tsaConfigurationContext;
    }

    public ClusterTool clusterTool(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            throw new IllegalStateException("Cannot control cluster tool: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        return new ClusterTool(this.ignite, this.instanceId, terracottaServer, this.tsaConfigurationContext.getTerracottaCommandLineEnvironment("ClusterTool"));
    }

    public ConfigTool configTool(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            throw new IllegalStateException("Cannot control config tool: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        return new ConfigTool(this.ignite, this.instanceId, terracottaServer, this.tsaConfigurationContext.getTerracottaCommandLineEnvironment("ConfigTool"));
    }

    public String licensePath(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            throw new IllegalStateException("Cannot get license path: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        return (String)IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteCallable & Serializable)() -> Agent.controller.getTsaLicensePath(this.instanceId, terracottaServer));
    }

    private void installAll() {
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        for (TerracottaServer terracottaServer : configurationManager.getServers()) {
            this.install(terracottaServer, topology);
        }
    }

    private void install(TerracottaServer terracottaServer, Topology topology) {
        this.installWithKitManager(terracottaServer, topology, this.localKitManager);
    }

    private void installWithKitManager(TerracottaServer terracottaServer, Topology topology, LocalKitManager localKitManager) {
        boolean isRemoteInstallationSuccessful;
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState != TerracottaServerState.NOT_INSTALLED) {
            throw new IllegalStateException("Cannot install: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
        }
        Distribution distribution = localKitManager.getDistribution();
        boolean offline = Boolean.parseBoolean(System.getProperty("offline", "false"));
        License license = this.tsaConfigurationContext.getLicense();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        localKitManager.setupLocalInstall(license, kitInstallationPath, offline);
        IgniteCallable & Serializable installTsaCallable = (IgniteCallable & Serializable)() -> Agent.controller.installTsa(this.instanceId, terracottaServer, license, localKitManager.getKitInstallationName(), distribution, topology);
        if (kitInstallationPath == null) {
            logger.info("Attempting to remotely install if distribution already exists on {}", (Object)terracottaServer.getHostname());
            isRemoteInstallationSuccessful = (Boolean)IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), installTsaCallable);
        } else {
            isRemoteInstallationSuccessful = false;
        }
        if (!isRemoteInstallationSuccessful) {
            try {
                logger.info("Uploading {} on {}", (Object)distribution, (Object)terracottaServer.getHostname());
                IgniteClientHelper.uploadKit(this.ignite, terracottaServer.getHostname(), this.instanceId, distribution, localKitManager.getKitInstallationName(), localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), installTsaCallable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + terracottaServer.getHostname(), e);
            }
        }
    }

    public Tsa upgrade(TerracottaServer server, Distribution newDistribution) {
        logger.info("Upgrading server {} to {}", (Object)server, (Object)newDistribution);
        this.uninstall(server);
        LocalKitManager localKitManager = new LocalKitManager(newDistribution);
        this.installWithKitManager(server, this.tsaConfigurationContext.getTopology(), localKitManager);
        return this;
    }

    private void uninstallAll() {
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer terracottaServer : topology.getServers()) {
            this.uninstall(terracottaServer);
        }
    }

    private void uninstall(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            return;
        }
        if (terracottaServerState != TerracottaServerState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
        }
        logger.info("Uninstalling TC server from {}", (Object)terracottaServer.getHostname());
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> Agent.controller.uninstallTsa(this.instanceId, this.tsaConfigurationContext.getTopology(), terracottaServer, this.localKitManager.getKitInstallationName());
        IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), uninstaller);
    }

    public Tsa createAll(String ... startUpArgs) {
        this.tsaConfigurationContext.getTopology().getServers().stream().map(server -> CompletableFuture.runAsync(() -> this.create((TerracottaServer)server, startUpArgs))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public Jcmd jcmd(TerracottaServer terracottaServer) {
        String whatFor = "Jcmd" + terracottaServer.getServerSymbolicName().getSymbolicName();
        TerracottaCommandLineEnvironment tcEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment(whatFor);
        return new Jcmd(this.ignite, this.instanceId, terracottaServer, tcEnv);
    }

    public Tsa create(TerracottaServer terracottaServer, String ... startUpArgs) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        switch (terracottaServerState) {
            case STARTING: 
            case STARTED_AS_ACTIVE: 
            case STARTED_AS_PASSIVE: 
            case STARTED_IN_DIAGNOSTIC_MODE: {
                return this;
            }
            case STOPPED: {
                logger.info("Creating TC server on {}", (Object)terracottaServer.getHostname());
                IgniteRunnable & Serializable tsaCreator = (IgniteRunnable & Serializable)() -> {
                    String whatFor = "Server-" + terracottaServer.getServerSymbolicName().getSymbolicName();
                    TerracottaCommandLineEnvironment cliEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment(whatFor);
                    Agent.controller.createTsa(this.instanceId, terracottaServer, cliEnv, Arrays.asList(startUpArgs));
                };
                IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), tsaCreator);
                return this;
            }
        }
        throw new IllegalStateException("Cannot create: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
    }

    public Tsa startAll(String ... startUpArgs) {
        this.tsaConfigurationContext.getTopology().getServers().stream().map(server -> CompletableFuture.runAsync(() -> this.start((TerracottaServer)server, startUpArgs))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public DisruptionController disruptionController() {
        return this.disruptionController;
    }

    public Tsa start(TerracottaServer terracottaServer, String ... startUpArgs) {
        this.create(terracottaServer, startUpArgs);
        IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteRunnable & Serializable)() -> Agent.controller.waitForTsaInState(this.instanceId, terracottaServer, EnumSet.of(TerracottaServerState.STARTED_AS_ACTIVE, TerracottaServerState.STARTED_AS_PASSIVE, TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE, TerracottaServerState.START_SUSPENDED)));
        return this;
    }

    public Tsa stopAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer terracottaServer : topology.getServers()) {
            try {
                this.stop(terracottaServer);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping all servers");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public Tsa stop(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == TerracottaServerState.STOPPED) {
            return this;
        }
        logger.info("Stopping TC server on {}", (Object)terracottaServer.getHostname());
        IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteRunnable & Serializable)() -> Agent.controller.stopTsa(this.instanceId, terracottaServer));
        return this;
    }

    public Tsa licenseAll() {
        this.licenseAll(null, false);
        return this;
    }

    public Tsa licenseAll(SecurityRootDirectory securityRootDirectory) {
        this.licenseAll(securityRootDirectory, false);
        return this;
    }

    public Tsa licenseAll(SecurityRootDirectory securityRootDirectory, boolean verbose) {
        ConfigurationManager configurationManager = this.tsaConfigurationContext.getTopology().getConfigurationManager();
        HashSet<ServerSymbolicName> notStartedServers = new HashSet<ServerSymbolicName>();
        for (TerracottaServer terracottaServer : configurationManager.getServers()) {
            TerracottaServerState terracottaServerState = this.getState(terracottaServer);
            if (terracottaServerState == TerracottaServerState.STARTED_AS_ACTIVE || terracottaServerState == TerracottaServerState.STARTED_AS_PASSIVE) continue;
            notStartedServers.add(terracottaServer.getServerSymbolicName());
        }
        if (!notStartedServers.isEmpty()) {
            throw new IllegalStateException("The following Terracotta servers are not started : " + notStartedServers);
        }
        if (configurationManager instanceof TcConfigManager) {
            TerracottaServer terracottaServer;
            Map<Object, Object> proxyTsaPorts = this.tsaConfigurationContext.getTopology().isNetDisruptionEnabled() ? this.disruptionController.updateTsaPortsWithProxy(this.tsaConfigurationContext.getTopology()) : new HashMap();
            terracottaServer = (TerracottaServer)this.tsaConfigurationContext.getTopology().getConfigurationManager().getServers().get(0);
            logger.info("Configuring cluster from {}", (Object)terracottaServer.getHostname());
            IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteRunnable & Serializable)() -> {
                TerracottaCommandLineEnvironment cliEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment("ClusterTool");
                Agent.controller.configure(this.instanceId, terracottaServer, this.tsaConfigurationContext.getTopology(), proxyTsaPorts, this.tsaConfigurationContext.getClusterName(), securityRootDirectory, cliEnv, verbose);
            });
            return this;
        }
        throw new IllegalStateException();
    }

    public Map<ServerSymbolicName, Integer> updateToProxiedPorts() {
        return this.disruptionController.updateTsaPortsWithProxy(this.tsaConfigurationContext.getTopology());
    }

    public Tsa activateAll() {
        Topology topology = this.tsaConfigurationContext.getTopology();
        List stripes = topology.getStripes();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        HashSet<ServerSymbolicName> notStartedServers = new HashSet<ServerSymbolicName>();
        for (TerracottaServer terracottaServer : configurationManager.getServers()) {
            TerracottaServerState terracottaServerState = this.getState(terracottaServer);
            if (terracottaServerState == TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE) continue;
            notStartedServers.add(terracottaServer.getServerSymbolicName());
        }
        if (!notStartedServers.isEmpty()) {
            throw new IllegalStateException("The following Terracotta servers are not started : " + notStartedServers);
        }
        if (configurationManager instanceof DynamicConfigManager) {
            TerracottaServer terracottaServer = (TerracottaServer)configurationManager.getServers().get(0);
            logger.info("Activating cluster from {}", (Object)terracottaServer.getHostname());
            IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteRunnable & Serializable)() -> {
                TerracottaCommandLineEnvironment cliEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment("ConfigTool");
                Agent.controller.configure(this.instanceId, terracottaServer, topology, null, this.tsaConfigurationContext.getClusterName(), null, cliEnv, false);
            });
            return this;
        }
        throw new IllegalStateException();
    }

    public TerracottaServerState getState(TerracottaServer terracottaServer) {
        return (TerracottaServerState)IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteCallable & Serializable)() -> Agent.controller.getTsaState(this.instanceId, terracottaServer));
    }

    public Map<ServerSymbolicName, Integer> getProxyGroupPortsForServer(TerracottaServer terracottaServer) {
        return (Map)IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteCallable & Serializable)() -> Agent.controller.getProxyGroupPortsForServer(this.instanceId, terracottaServer));
    }

    public Collection<TerracottaServer> getStarted() {
        ArrayList<TerracottaServer> allRunningServers = new ArrayList<TerracottaServer>();
        allRunningServers.addAll(this.getActives());
        allRunningServers.addAll(this.getPassives());
        allRunningServers.addAll(this.getDiagnosticModeSevers());
        return allRunningServers;
    }

    public Collection<TerracottaServer> getStopped() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STOPPED) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public Collection<TerracottaServer> getPassives() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_AS_PASSIVE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public TerracottaServer getPassive() {
        Collection<TerracottaServer> servers = this.getPassives();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one Passive Terracotta server, found " + servers.size());
    }

    public Collection<TerracottaServer> getActives() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_AS_ACTIVE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public Collection<TerracottaServer> getServer(ServerSymbolicName symbolicName) {
        return this.tsaConfigurationContext.getTopology().getServers().stream().filter(server -> server.getServerSymbolicName().equals((Object)symbolicName)).collect(Collectors.toList());
    }

    public TerracottaServer getServer(int stripeIndex, int serverIndex) {
        return this.tsaConfigurationContext.getTopology().getServer(stripeIndex, serverIndex);
    }

    public Collection<Integer> getStripeIdOf(ServerSymbolicName symbolicName) {
        ArrayList<Integer> stripeIndices = new ArrayList<Integer>();
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        for (int i = 0; i < stripes.size(); ++i) {
            List stripe = (List)stripes.get(i);
            if (!stripe.stream().anyMatch(server -> server.getServerSymbolicName().equals((Object)symbolicName))) continue;
            stripeIndices.add(i);
        }
        return stripeIndices;
    }

    public TerracottaServer getActive() {
        Collection<TerracottaServer> servers = this.getActives();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one Active Terracotta server, found " + servers.size());
    }

    public Collection<TerracottaServer> getDiagnosticModeSevers() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public TerracottaServer getDiagnosticModeServer() {
        Collection<TerracottaServer> servers = this.getDiagnosticModeSevers();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one diagnostic mode server, found " + servers.size());
    }

    public URI uri() {
        if (this.disruptionController == null) {
            throw new IllegalStateException("uri cannot be built from a client lambda - please call uri() from the test code instead");
        }
        Topology topology = this.tsaConfigurationContext.getTopology();
        Map proxyTsaPorts = topology.isNetDisruptionEnabled() ? this.disruptionController.getProxyTsaPorts() : Collections.emptyMap();
        return topology.getDistribution().createDistributionController().tsaUri((Collection)topology.getServers(), proxyTsaPorts);
    }

    public RemoteFolder browse(TerracottaServer terracottaServer, String root) {
        String path = (String)IgniteClientHelper.executeRemotely(this.ignite, terracottaServer.getHostname(), (IgniteCallable & Serializable)() -> Agent.controller.getTsaInstallPath(this.instanceId, terracottaServer));
        return new RemoteFolder(this.ignite, terracottaServer.getHostname(), path, root);
    }

    public void uploadPlugin(File localPluginFile) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer server : topology.getServers()) {
            try {
                this.browse(server, topology.getDistribution().createDistributionController().pluginJarsRootFolderName(topology.getDistribution())).upload(localPluginFile);
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error uploading TSA plugin");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void uploadDataDirectories(File localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        if (configurationManager instanceof TcConfigManager) {
            TcConfigManager tcConfigProvider = (TcConfigManager)configurationManager;
            List tcConfigs = tcConfigProvider.getTcConfigs();
            for (TcConfig tcConfig : tcConfigs) {
                Collection dataDirectories = tcConfig.getDataDirectories().values();
                List servers = tcConfig.getServers();
                for (String directory : dataDirectories) {
                    for (TerracottaServer server : servers) {
                        try {
                            File localFile = new File(localRootPath, server.getServerSymbolicName().getSymbolicName() + "/" + directory);
                            this.browse(server, directory).upload(localFile);
                        }
                        catch (IOException ioe) {
                            exceptions.add(ioe);
                        }
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error uploading TSA data directories");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void downloadDataDirectories(File localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        if (configurationManager instanceof TcConfigManager) {
            TcConfigManager tcConfigProvider = (TcConfigManager)configurationManager;
            List tcConfigs = tcConfigProvider.getTcConfigs();
            for (TcConfig tcConfig : tcConfigs) {
                Map dataDirectories = tcConfig.getDataDirectories();
                List servers = tcConfig.getServers();
                for (TerracottaServer server : servers) {
                    for (Map.Entry entry : dataDirectories.entrySet()) {
                        String directory = (String)entry.getValue();
                        try {
                            this.browse(server, directory).downloadTo(new File(localRootPath + "/" + server.getServerSymbolicName().getSymbolicName(), directory));
                        }
                        catch (IOException ioe) {
                            exceptions.add(ioe);
                        }
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading TSA data directories");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public List<ConfigToolExecutionResult> attachStripe(TerracottaServer ... newServers) {
        if (newServers == null || newServers.length == 0) {
            throw new IllegalArgumentException("Servers list should be non-null and non-empty");
        }
        for (TerracottaServer server : newServers) {
            this.install(server, this.tsaConfigurationContext.getTopology());
            this.start(server, new String[0]);
        }
        this.tsaConfigurationContext.getTopology().addStripe(newServers);
        ArrayList<ConfigToolExecutionResult> results = new ArrayList<ConfigToolExecutionResult>();
        if (newServers.length > 1) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("attach");
            command.add("-t");
            command.add("node");
            command.add("-d");
            command.add(newServers[0].getHostPort());
            for (int i = 1; i < newServers.length; ++i) {
                command.add("-s");
                command.add(newServers[i].getHostPort());
            }
            ConfigToolExecutionResult result = this.configTool(newServers[0]).executeCommand(command.toArray(new String[0]));
            if (result.getExitStatus() != 0) {
                throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
            }
            results.add(result);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("attach");
        command.add("-t");
        command.add("stripe");
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        TerracottaServer existingServer = (TerracottaServer)((List)stripes.get(0)).get(0);
        command.add("-d");
        command.add(existingServer.getHostPort());
        for (TerracottaServer newServer : newServers) {
            command.add("-s");
            command.add(newServer.getHostPort());
        }
        ConfigToolExecutionResult result = this.configTool(existingServer).executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
        }
        results.add(result);
        return results;
    }

    public ConfigToolExecutionResult detachStripe(int stripeIndex) {
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        if (stripes.size() == 1) {
            throw new IllegalArgumentException("Cannot delete the only stripe from cluster");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("detach");
        command.add("-t");
        command.add("stripe");
        List toDetachStripe = (List)stripes.remove(stripeIndex);
        TerracottaServer destination = (TerracottaServer)((List)stripes.get(0)).get(0);
        command.add("-d");
        command.add(destination.getHostPort());
        command.add("-s");
        command.add(((TerracottaServer)toDetachStripe.get(0)).getHostPort());
        ConfigToolExecutionResult result = this.configTool(destination).executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
        }
        this.tsaConfigurationContext.getTopology().removeStripe(stripeIndex);
        return result;
    }

    public ConfigToolExecutionResult attachNodes(int stripeIndex, TerracottaServer ... newServers) {
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        if (newServers == null || newServers.length == 0) {
            throw new IllegalArgumentException("Servers list should be non-null and non-empty");
        }
        for (TerracottaServer newServer : newServers) {
            this.install(newServer, this.tsaConfigurationContext.getTopology());
            this.start(newServer, new String[0]);
            this.tsaConfigurationContext.getTopology().addServer(stripeIndex, newServer);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("attach");
        command.add("-t");
        command.add("node");
        TerracottaServer existingServer = (TerracottaServer)((List)stripes.get(stripeIndex)).get(0);
        command.add("-d");
        command.add(existingServer.getHostPort());
        for (TerracottaServer newServer : newServers) {
            command.add("-s");
            command.add(newServer.getHostPort());
        }
        ConfigToolExecutionResult result = this.configTool(existingServer).executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
        }
        return result;
    }

    public ConfigToolExecutionResult detachNode(int stripeIndex, int serverIndex) {
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        List servers = (List)stripes.remove(stripeIndex);
        if (serverIndex < -1 || serverIndex >= servers.size()) {
            throw new IllegalArgumentException("serverIndex should be a non-negative integer less than server count");
        }
        TerracottaServer toDetach = (TerracottaServer)servers.remove(serverIndex);
        if (servers.size() == 0 && stripes.size() == 0) {
            throw new IllegalArgumentException("Cannot delete the only server from the cluster");
        }
        TerracottaServer destination = stripes.size() != 0 ? (TerracottaServer)((List)stripes.get(0)).get(0) : (TerracottaServer)servers.get(0);
        ArrayList<String> command = new ArrayList<String>();
        command.add("detach");
        command.add("-t");
        command.add("node");
        command.add("-d");
        command.add(destination.getHostPort());
        command.add("-s");
        command.add(toDetach.getHostPort());
        ConfigToolExecutionResult result = this.configTool(destination).executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
        }
        this.tsaConfigurationContext.getTopology().removeServer(stripeIndex, serverIndex);
        return result;
    }

    public Tsa attachAll() {
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        for (List stripe : stripes) {
            if (stripe.size() <= 1) continue;
            ArrayList<String> command = new ArrayList<String>();
            command.add("attach");
            command.add("-t");
            command.add("node");
            command.add("-d");
            command.add(((TerracottaServer)stripe.get(0)).getHostPort());
            for (int i = 1; i < stripe.size(); ++i) {
                command.add("-s");
                command.add(((TerracottaServer)stripe.get(i)).getHostPort());
            }
            ConfigToolExecutionResult result = this.configTool((TerracottaServer)stripe.get(0)).executeCommand(command.toArray(new String[0]));
            if (result.getExitStatus() == 0) continue;
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
        }
        if (stripes.size() > 1) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("attach");
            command.add("-t");
            command.add("stripe");
            command.add("-d");
            command.add(((TerracottaServer)((List)stripes.get(0)).get(0)).getHostPort());
            for (int i = 1; i < stripes.size(); ++i) {
                List stripe = (List)stripes.get(i);
                command.add("-s");
                command.add(((TerracottaServer)stripe.get(0)).getHostPort());
            }
            ConfigToolExecutionResult result = this.configTool((TerracottaServer)((List)stripes.get(0)).get(0)).executeCommand(command.toArray(new String[0]));
            if (result.getExitStatus() != 0) {
                throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopAll();
        if (!Boolean.parseBoolean(AngelaProperties.SKIP_UNINSTALL.getValue())) {
            this.uninstallAll();
        }
        if (this.tsaConfigurationContext.getTopology().isNetDisruptionEnabled()) {
            try {
                this.disruptionController.close();
            }
            catch (Exception e) {
                logger.error("Error when trying to close traffic controller : {}", (Object)e.getMessage());
            }
        }
    }
}

