/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.net;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.DisruptorState;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class ServerToServerDisruptor
implements Disruptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerToServerDisruptor.class);
    private final Map<ServerSymbolicName, Collection<ServerSymbolicName>> linkedServers;
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final Topology topology;
    private final Consumer<Disruptor> closeHook;
    private volatile DisruptorState state;

    ServerToServerDisruptor(Ignite ignite, InstanceId instanceId, Topology topology, Map<ServerSymbolicName, Collection<ServerSymbolicName>> linkedServers, Consumer<Disruptor> closeHook) {
        this.ignite = ignite;
        this.instanceId = instanceId;
        this.topology = topology;
        this.linkedServers = linkedServers;
        this.closeHook = closeHook;
        this.state = DisruptorState.UNDISRUPTED;
    }

    public void disrupt() {
        if (this.state != DisruptorState.UNDISRUPTED) {
            throw new IllegalStateException("Illegal state before disrupt:" + this.state);
        }
        LOGGER.info("blocking {}", (Object)this);
        HashMap<ServerSymbolicName, TerracottaServer> topologyServers = new HashMap<ServerSymbolicName, TerracottaServer>();
        for (TerracottaServer terracottaServer : this.topology.getServers()) {
            topologyServers.put(terracottaServer.getServerSymbolicName(), terracottaServer);
        }
        for (Map.Entry entry : this.linkedServers.entrySet()) {
            TerracottaServer server = (TerracottaServer)topologyServers.get(entry.getKey());
            Collection<TerracottaServer> otherServers = Collections.unmodifiableCollection(((Collection)entry.getValue()).stream().map(topologyServers::get).collect(Collectors.toList()));
            IgniteClientHelper.executeRemotely(this.ignite, server.getHostname(), ServerToServerDisruptor.blockRemotely(this.instanceId, server, otherServers));
        }
        this.state = DisruptorState.DISRUPTED;
    }

    public void undisrupt() {
        if (this.state != DisruptorState.DISRUPTED) {
            throw new IllegalStateException("Illegal state before undisrupt:" + this.state);
        }
        LOGGER.info("undisrupting {}", (Object)this);
        HashMap<ServerSymbolicName, TerracottaServer> topologyServers = new HashMap<ServerSymbolicName, TerracottaServer>();
        for (TerracottaServer terracottaServer : this.topology.getServers()) {
            topologyServers.put(terracottaServer.getServerSymbolicName(), terracottaServer);
        }
        for (Map.Entry entry : this.linkedServers.entrySet()) {
            TerracottaServer server = (TerracottaServer)topologyServers.get(entry.getKey());
            Collection<TerracottaServer> otherServers = Collections.unmodifiableCollection(((Collection)entry.getValue()).stream().map(topologyServers::get).collect(Collectors.toList()));
            IgniteClientHelper.executeRemotelyAsync(this.ignite, server.getHostname(), ServerToServerDisruptor.undisruptRemotely(this.instanceId, server, otherServers)).get();
        }
        this.state = DisruptorState.UNDISRUPTED;
    }

    public void close() {
        if (this.state == DisruptorState.DISRUPTED) {
            this.undisrupt();
        }
        if (this.state == DisruptorState.UNDISRUPTED) {
            this.closeHook.accept(this);
            this.state = DisruptorState.CLOSED;
        }
    }

    Map<ServerSymbolicName, Collection<ServerSymbolicName>> getLinkedServers() {
        return this.linkedServers;
    }

    private static IgniteRunnable blockRemotely(InstanceId instanceId, TerracottaServer server, Collection<TerracottaServer> otherServers) {
        return (IgniteRunnable & Serializable)() -> Agent.controller.disrupt(instanceId, server, otherServers);
    }

    private static IgniteRunnable undisruptRemotely(InstanceId instanceId, TerracottaServer server, Collection<TerracottaServer> otherServers) {
        return (IgniteRunnable & Serializable)() -> Agent.controller.undisrupt(instanceId, server, otherServers);
    }

    public String toString() {
        return "ServerToServerDisruptor{linkedServers=" + this.linkedServers.entrySet().stream().map(e -> ((ServerSymbolicName)e.getKey()).getSymbolicName() + "->" + ((Collection)e.getValue()).stream().map(ServerSymbolicName::getSymbolicName).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(",", "{", "}")) + '}';
    }
}

