/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Client;
import org.terracotta.angela.client.ClientArrayFuture;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.Jcmd;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.topology.InstanceId;

public class ClientArray
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClientArray.class);
    private final Ignite ignite;
    private final Supplier<InstanceId> instanceIdSupplier;
    private final LocalKitManager localKitManager;
    private final Map<ClientId, Client> clients = new HashMap<ClientId, Client>();
    private final int ignitePort;
    private final ClientArrayConfigurationContext clientArrayConfigurationContext;
    private boolean closed = false;

    ClientArray(Ignite ignite, int ignitePort, Supplier<InstanceId> instanceIdSupplier, ClientArrayConfigurationContext clientArrayConfigurationContext) {
        this.ignitePort = ignitePort;
        this.clientArrayConfigurationContext = clientArrayConfigurationContext;
        this.instanceIdSupplier = instanceIdSupplier;
        this.ignite = ignite;
        this.localKitManager = new LocalKitManager(clientArrayConfigurationContext.getClientArrayTopology().getDistribution());
        this.installAll();
    }

    private void installAll() {
        this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds().forEach(this::install);
    }

    private void install(ClientId clientId) {
        boolean offline = Boolean.parseBoolean(System.getProperty("offline", "false"));
        logger.info("Setting up locally the extracted install to be deployed remotely");
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(this.clientArrayConfigurationContext.getLicense(), kitInstallationPath, offline);
        try {
            logger.info("installing the client jars to {}", (Object)clientId);
            Client client = new Client(this.ignite, this.ignitePort, this.instanceIdSupplier.get(), clientId, this.clientArrayConfigurationContext.getTerracottaCommandLineEnvironment(), this.localKitManager);
            this.clients.put(clientId, client);
        }
        catch (Exception e) {
            logger.error("Cannot upload client jars to {}: {}", new Object[]{clientId, e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    private void uninstallAll() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            try {
                this.uninstall(clientId);
            }
            catch (Exception ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error uninstalling some clients");
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }

    private void uninstall(ClientId clientId) throws IOException {
        logger.info("uninstalling {}", (Object)clientId);
        Client client = this.clients.get(clientId);
        try {
            if (client != null) {
                client.close();
            }
        }
        finally {
            this.clients.remove(clientId);
        }
    }

    public Jcmd jcmd(Client client) {
        TerracottaCommandLineEnvironment tcEnv = this.clientArrayConfigurationContext.getTerracottaCommandLineEnvironment();
        return new Jcmd(this.ignite, this.instanceIdSupplier.get(), client, this.ignitePort, tcEnv);
    }

    public void stopAll() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            try {
                this.stop(clientId);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error stopping some clients");
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }

    public void stop(ClientId clientId) {
        logger.info("stopping {}", (Object)clientId);
        Client client = this.clients.get(clientId);
        if (client != null) {
            client.stop();
        }
    }

    public ClientArrayConfigurationContext getClientArrayConfigurationContext() {
        return this.clientArrayConfigurationContext;
    }

    public ClientArrayFuture executeOnAll(ClientJob clientJob) {
        return this.executeOnAll(clientJob, 1);
    }

    public ClientArrayFuture executeOnAll(ClientJob clientJob, int jobsPerClient) {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            for (int i = 1; i <= jobsPerClient; ++i) {
                futures.add(this.executeOn(clientId, clientJob));
            }
        }
        return new ClientArrayFuture(futures);
    }

    public Future<Void> executeOn(ClientId clientId, ClientJob clientJob) {
        return this.clients.get(clientId).submit(clientId, clientJob);
    }

    public RemoteFolder browse(Client client, String remoteLocation) {
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.instanceWorkDir(client.getInstanceId());
        String clientWorkDir = (String)IgniteClientHelper.executeRemotely(this.ignite, client.getHostname(), this.ignitePort, callable);
        return new RemoteFolder(this.ignite, client.getHostname(), this.ignitePort, clientWorkDir, remoteLocation);
    }

    public void download(String remoteLocation, File localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Client client : this.clients.values()) {
            try {
                this.browse(client, remoteLocation).downloadTo(new File(localRootPath, client.getSymbolicName()));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!Boolean.parseBoolean(AngelaProperties.SKIP_UNINSTALL.getValue())) {
            this.uninstallAll();
        }
    }

    public Collection<Client> getClients() {
        return Collections.unmodifiableCollection(this.clients.values());
    }
}

