/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.filesystem.TransportableFile;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.topology.InstanceId;

public class ClusterMonitor
implements AutoCloseable {
    private final Ignite ignite;
    private final int ignitePort;
    private final Path workingPath;
    private final Set<String> hostnames;
    private final Map<HardwareMetric, MonitoringCommand> commands;
    private boolean closed = false;

    ClusterMonitor(Ignite ignite, int ignitePort, InstanceId instanceId, Set<String> hostnames, Map<HardwareMetric, MonitoringCommand> commands) {
        this.ignite = ignite;
        this.ignitePort = ignitePort;
        this.workingPath = Agent.WORK_DIR.resolve(instanceId.toString());
        this.hostnames = hostnames;
        this.commands = commands;
    }

    public ClusterMonitor startOnAll() {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        for (String hostname : this.hostnames) {
            try {
                IgniteRunnable & Serializable igniteRunnable = (IgniteRunnable & Serializable)() -> Agent.controller.startHardwareMonitoring(this.workingPath.toString(), this.commands);
                IgniteClientHelper.executeRemotely(this.ignite, hostname, this.ignitePort, igniteRunnable);
            }
            catch (Exception e) {
                exceptions.add(new RuntimeException("Error starting hardware monitoring on " + hostname, e));
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error starting cluster monitors");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public ClusterMonitor stopOnAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String hostname : this.hostnames) {
            try {
                IgniteClientHelper.executeRemotely(this.ignite, hostname, this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.stopHardwareMonitoring());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping cluster monitors");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public void downloadTo(File location) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (String hostname : this.hostnames) {
            try {
                Path metricsPath = this.workingPath.resolve("metrics");
                new RemoteFolder(this.ignite, hostname, this.ignitePort, null, metricsPath.toString()).downloadTo(new File(location, hostname));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void processMetrics(BiConsumer<String, TransportableFile> processor) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String hostname : this.hostnames) {
            try {
                Path metricsPath = this.workingPath.resolve("metrics");
                RemoteFolder remoteFolder = new RemoteFolder(this.ignite, hostname, this.ignitePort, null, metricsPath.toString());
                remoteFolder.list().forEach(remoteFile -> processor.accept(hostname, remoteFile.toTransportableFile()));
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public boolean isMonitoringRunning(HardwareMetric metric) {
        for (String hostname : this.hostnames) {
            boolean running = (Boolean)IgniteClientHelper.executeRemotely(this.ignite, hostname, this.ignitePort, (IgniteCallable & Serializable)() -> Agent.controller.isMonitoringRunning(metric));
            if (running) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopOnAll();
    }
}

