/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.support.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class NodeOutputRule
implements TestRule {
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private final Map<String, NodeLog> outputs = new ConcurrentHashMap<String, NodeLog>();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PrintStream original = System.out;
                try {
                    System.setOut(new PrintStream((OutputStream)new LineOutputStream(original, 1024, line -> NodeOutputRule.this.onNewLine(line)), true, DEFAULT_ENCODING));
                    base.evaluate();
                }
                finally {
                    System.setOut(original);
                }
            }
        };
    }

    public NodeLog getLog(int stripeId, int nodeId) {
        return this.outputs.computeIfAbsent(stripeId + "-" + nodeId, key -> new NodeLog());
    }

    public void clearLog(int stripeId, int nodeId) {
        this.getLog(stripeId, nodeId).clearLog();
    }

    public void clearLog() {
        this.outputs.values().forEach(NodeLog::clearLog);
    }

    private void onNewLine(String line) {
        int end;
        int middle;
        int start = line.indexOf(" - [node-");
        if (start != -1 && (middle = line.indexOf(45, start + 9)) != -1 && (end = line.indexOf(93, middle + 1)) != -1) {
            int stripeId = Integer.parseInt(line.substring(start + 9, middle));
            int nodeId = Integer.parseInt(line.substring(middle + 1, end));
            this.getLog(stripeId, nodeId).append(line);
        }
    }

    public static class NodeLog {
        private final Deque<String> logs = new ConcurrentLinkedDeque<String>();

        public Stream<String> streamLogs() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.logs.iterator(), 16), false);
        }

        public Stream<String> streamLogsDescending() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.logs.descendingIterator(), 16), false);
        }

        public void clearLog() {
            this.logs.clear();
        }

        private void append(String line) {
            this.logs.offer(line);
        }

        public String toString() {
            return String.join((CharSequence)"", this.logs);
        }
    }

    private static class LineOutputStream
    extends OutputStream {
        private static final byte EOL = 10;
        private final OutputStream next;
        private final ByteBuffer buffer;
        private final Consumer<String> onNewLine;

        public LineOutputStream(OutputStream next, int maximumLineLength, Consumer<String> onNewLine) {
            this.onNewLine = onNewLine;
            this.next = next;
            this.buffer = ByteBuffer.allocate(maximumLineLength);
        }

        @Override
        public void write(int b) throws IOException {
            this.next.write(b);
            if (b == 10) {
                String line = new String(this.buffer.array(), 0, this.buffer.position(), DEFAULT_ENCODING) + "\n";
                this.onNewLine.accept(line);
                this.buffer.clear();
            } else if (this.buffer.hasRemaining()) {
                this.buffer.put((byte)b);
            }
        }

        @Override
        public void close() throws IOException {
            this.next.close();
        }
    }
}

