/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.net;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.DisruptionProviderFactory;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.DisruptorState;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.HostPort;

public class ClientToServerDisruptor
implements Disruptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientToServerDisruptor.class);
    private static final DisruptionProvider DISRUPTION_PROVIDER = DisruptionProviderFactory.getDefault();
    private final Map<ServerSymbolicName, Disruptor> links = new HashMap<ServerSymbolicName, Disruptor>();
    private final Map<ServerSymbolicName, InetSocketAddress> endPoints = new HashMap<ServerSymbolicName, InetSocketAddress>();
    private final Consumer<Disruptor> closeHook;
    private volatile DisruptorState state;

    ClientToServerDisruptor(Topology topology, Consumer<Disruptor> closeHook, Map<ServerSymbolicName, Integer> proxiedTsaPorts) {
        this.closeHook = closeHook;
        for (TerracottaServer server : topology.getServers()) {
            InetSocketAddress clientEndPoint = DISRUPTION_PROVIDER.isProxyBased() ? null : new InetSocketAddress("localhost", -1);
            InetSocketAddress proxyEndPoint = DISRUPTION_PROVIDER.isProxyBased() ? new InetSocketAddress("localhost", (int)proxiedTsaPorts.get(server.getServerSymbolicName())) : null;
            InetSocketAddress serverEndPoint = new InetSocketAddress(server.getHostname(), server.getTsaPort());
            this.endPoints.putIfAbsent(server.getServerSymbolicName(), DISRUPTION_PROVIDER.isProxyBased() ? proxyEndPoint : serverEndPoint);
            LOGGER.debug("Server {} endpoint {}", (Object)server.getServerSymbolicName().getSymbolicName(), (Object)this.endPoints.get(server.getServerSymbolicName()));
            this.links.computeIfAbsent(server.getServerSymbolicName(), s -> DISRUPTION_PROVIDER.createLink(DISRUPTION_PROVIDER.isProxyBased() ? proxyEndPoint : clientEndPoint, serverEndPoint));
        }
        this.state = DisruptorState.UNDISRUPTED;
    }

    public void disrupt(Collection<ServerSymbolicName> servers) {
        if (this.state != DisruptorState.UNDISRUPTED) {
            throw new IllegalStateException("Illegal state before disrupt: " + this.state);
        }
        LOGGER.debug("disrupting client to servers");
        for (ServerSymbolicName server : servers) {
            this.links.get(server).disrupt();
        }
        this.state = DisruptorState.DISRUPTED;
    }

    public void disrupt() {
        this.disrupt(this.links.keySet());
    }

    public void undisrupt() {
        if (this.state != DisruptorState.DISRUPTED) {
            throw new IllegalStateException("Illegal state before undisrupt: " + this.state);
        }
        LOGGER.debug("undisrupting client to servers");
        for (Disruptor link : this.links.values()) {
            link.undisrupt();
        }
        this.state = DisruptorState.UNDISRUPTED;
    }

    public void close() throws Exception {
        if (this.state == DisruptorState.DISRUPTED) {
            this.undisrupt();
        }
        if (this.state == DisruptorState.UNDISRUPTED) {
            this.links.values().forEach(arg_0 -> ((DisruptionProvider)DISRUPTION_PROVIDER).removeLink(arg_0));
            this.closeHook.accept(this);
            this.state = DisruptorState.CLOSED;
        }
    }

    public URI uri() {
        return URI.create("terracotta://" + this.getHostPortList());
    }

    public URI uri(TerracottaServer ... servers) {
        return URI.create("terracotta://" + this.getHostPortList(servers));
    }

    public URI diagnosticURI(TerracottaServer server) {
        return URI.create("diagnostics://" + this.getHostPortList(server));
    }

    private String getHostPortList() {
        return this.getHostPortList(this.endPoints.keySet());
    }

    private String getHostPortList(TerracottaServer ... servers) {
        return this.getHostPortList(Arrays.stream(servers).map(TerracottaServer::getServerSymbolicName).collect(Collectors.toList()));
    }

    private String getHostPortList(Collection<ServerSymbolicName> servers) {
        return servers.stream().map(this.endPoints::get).map(s -> new HostPort(s.getHostName(), s.getPort()).getHostPort()).collect(Collectors.joining(","));
    }
}

