/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.topology.InstanceId;

public class Client
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final int ignitePort;
    private final InstanceId instanceId;
    private final ClientId clientId;
    private final Ignite ignite;
    private final int subClientPid;
    private boolean stopped = false;
    private boolean closed = false;

    Client(Ignite ignite, int ignitePort, InstanceId instanceId, ClientId clientId, TerracottaCommandLineEnvironment tcEnv, LocalKitManager localKitManager) {
        this.ignitePort = ignitePort;
        this.instanceId = instanceId;
        this.clientId = clientId;
        this.ignite = ignite;
        this.subClientPid = this.spawnSubClient(Objects.requireNonNull(tcEnv), Objects.requireNonNull(localKitManager));
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    int getPid() {
        return this.subClientPid;
    }

    private int spawnSubClient(TerracottaCommandLineEnvironment tcEnv, LocalKitManager localKitManager) {
        logger.info("Spawning client '{}' on {}", (Object)this.instanceId, (Object)this.clientId);
        try {
            IgniteClientHelper.uploadClientJars(this.ignite, this.getHostname(), this.ignitePort, this.instanceId, this.listClasspathFiles(localKitManager));
            IgniteCallable & Serializable igniteCallable = (IgniteCallable & Serializable)() -> Agent.controller.spawnClient(this.instanceId, tcEnv);
            int pid = (Integer)IgniteClientHelper.executeRemotely(this.ignite, this.getHostname(), this.ignitePort, igniteCallable);
            logger.info("client '{}' on {} started with PID {}", new Object[]{this.instanceId, this.clientId, pid});
            return pid;
        }
        catch (Exception e) {
            logger.error("Cannot create client on {}: {}", new Object[]{this.clientId, e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    private List<File> listClasspathFiles(LocalKitManager localKitManager) {
        ArrayList<File> files = new ArrayList<File>();
        File javaHome = new File(System.getProperty("java.home"));
        String[] classpathJarNames = System.getProperty("java.class.path").split(File.pathSeparator);
        boolean substituteClientJars = localKitManager.getDistribution() != null;
        ArrayList<File> jars = new ArrayList<File>();
        for (String classpathJarName : classpathJarNames) {
            if (classpathJarName.startsWith(javaHome.getPath()) || classpathJarName.startsWith(javaHome.getParentFile().getPath())) {
                logger.debug("Skipping {} as it is part of the JVM", (Object)classpathJarName);
                continue;
            }
            File classpathFile = new File(classpathJarName);
            File equivalentClientJar = localKitManager.equivalentClientJar(classpathFile);
            if (substituteClientJars && equivalentClientJar != null) {
                logger.debug("Skipping upload of classpath file as kit contains equivalent jar in client libs : {}", (Object)classpathFile.getName());
                jars.add(equivalentClientJar);
                continue;
            }
            logger.debug("Uploading classpath file : {}", (Object)classpathFile.getName());
            files.add(classpathFile);
        }
        if (substituteClientJars) {
            logger.info("Enhancing client classpath with client jars of {}", (Object)localKitManager.getDistribution());
            files.addAll(jars);
            logger.debug("Adding clients jars : {}", jars);
        }
        return files;
    }

    Future<Void> submit(ClientId clientId, ClientJob clientJob) {
        IgniteFuture igniteFuture = IgniteClientHelper.executeRemotelyAsync(this.ignite, this.instanceId.toString(), this.ignitePort, (IgniteCallable & Serializable)() -> {
            try {
                clientJob.run(new Cluster(this.ignite, clientId));
                return null;
            }
            catch (Throwable t) {
                throw new RemoteExecutionException("Remote ClientJob failed", Client.exceptionToString(t));
            }
        });
        return new ClientJobFuture<Void>(igniteFuture);
    }

    private static String exceptionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public RemoteFolder browse(String root) {
        return new RemoteFolder(this.ignite, this.instanceId.toString(), this.ignitePort, null, root);
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String getHostname() {
        return this.clientId.getHostname();
    }

    public String getSymbolicName() {
        return this.clientId.getSymbolicName().getSymbolicName();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stop();
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            logger.info("Wiping up client '{}' on {}", (Object)this.instanceId, (Object)this.clientId);
            IgniteClientHelper.executeRemotely(this.ignite, this.getHostname(), this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.deleteClient(this.instanceId));
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        logger.info("Killing client '{}' on {}", (Object)this.instanceId, (Object)this.clientId);
        IgniteClientHelper.executeRemotely(this.ignite, this.getHostname(), this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.stopClient(this.instanceId, this.subClientPid));
    }

    public static class RemoteExecutionException
    extends Exception {
        private final String remoteStackTrace;
        private String tabulation = "\t";

        RemoteExecutionException(String message, String remoteStackTrace) {
            super(message);
            this.remoteStackTrace = remoteStackTrace;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "; Remote stack trace is:" + System.lineSeparator() + this.tabulation + "{{{" + System.lineSeparator() + this.tabulation + this.remoteStackTrace() + "}}}";
        }

        private String remoteStackTrace() {
            return this.remoteStackTrace.replaceAll(System.lineSeparator(), System.lineSeparator() + this.tabulation);
        }

        public void setRemoteStackTraceIndentation(int indentation) {
            StringBuilder sb = new StringBuilder(indentation);
            for (int i = 0; i < indentation; ++i) {
                sb.append('\t');
            }
            this.tabulation = sb.toString();
        }
    }

    static class ClientJobFuture<V>
    implements Future<V> {
        private final IgniteFuture<V> igniteFuture;

        ClientJobFuture(IgniteFuture<V> igniteFuture) {
            this.igniteFuture = igniteFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.igniteFuture.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.igniteFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.igniteFuture.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return (V)this.igniteFuture.get();
            }
            catch (IgniteInterruptedException iie) {
                throw (InterruptedException)new InterruptedException().initCause(iie);
            }
            catch (IgniteException ie) {
                RemoteExecutionException ree = ClientJobFuture.lookForRemoteExecutionException(ie);
                if (ree != null) {
                    throw new ExecutionException("Client job execution failed", ree);
                }
                throw new ExecutionException("Client job execution failed", ie);
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (V)this.igniteFuture.get(timeout, unit);
            }
            catch (IgniteInterruptedException iie) {
                throw (InterruptedException)new InterruptedException().initCause(iie);
            }
            catch (IgniteFutureTimeoutException ifte) {
                throw (TimeoutException)new TimeoutException().initCause(ifte);
            }
            catch (IgniteException ie) {
                RemoteExecutionException ree = ClientJobFuture.lookForRemoteExecutionException(ie);
                if (ree != null) {
                    throw new ExecutionException("Client job execution failed", ree);
                }
                throw new ExecutionException("Client job execution failed", ie);
            }
        }

        private static RemoteExecutionException lookForRemoteExecutionException(Throwable t) {
            if (t instanceof RemoteExecutionException) {
                return (RemoteExecutionException)t;
            }
            if (t == null) {
                return null;
            }
            return ClientJobFuture.lookForRemoteExecutionException(t.getCause());
        }
    }
}

