/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.remote.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.LogOutputStream;

class SshLogOutputStream
extends LogOutputStream {
    private final String serverName;
    private final Session.Command cmd;
    private final AtomicBoolean started = new AtomicBoolean(false);

    SshLogOutputStream(String serverName, Session.Command cmd) {
        this.serverName = serverName;
        this.cmd = cmd;
    }

    protected void processLine(String line) {
        ExternalLoggers.sshLogger.info("[{}] {}", (Object)this.serverName, (Object)line);
        if (line.contains("Agent is ready")) {
            this.started.set(true);
        }
    }

    public void waitForStartedState() {
        while (!this.started.get()) {
            if (!this.cmd.isOpen()) {
                throw new RuntimeException("agent refused to start");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

