/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.net;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;

public class SplitCluster {
    private final Set<ServerSymbolicName> servers;

    public SplitCluster(TerracottaServer server) {
        this(Collections.singleton(server));
    }

    public SplitCluster(Collection<TerracottaServer> servers) {
        this.servers = Collections.unmodifiableSet(servers.stream().map(TerracottaServer::getServerSymbolicName).collect(Collectors.toSet()));
    }

    public Set<ServerSymbolicName> getServers() {
        return this.servers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitCluster that = (SplitCluster)o;
        return this.servers != null ? this.servers.equals(that.servers) : that.servers == null;
    }

    public int hashCode() {
        return this.servers != null ? this.servers.hashCode() : 0;
    }

    public String toString() {
        return "SplitCluster{servers=" + this.servers.stream().map(ServerSymbolicName::getSymbolicName).collect(Collectors.joining(",", "[", "]")) + '}';
    }
}

