/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.Voter;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.MonitoringConfigurationContext;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.client.remote.agent.RemoteAgentLauncher;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.IpUtils;

public class ClusterFactory
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFactory.class);
    private static final String TSA = "tsa";
    private static final String TMS = "tms";
    private static final String CLIENT_ARRAY = "clientArray";
    private static final String MONITOR = "monitor";
    private static final String VOTER = "voter";
    private static final DateTimeFormatter PATH_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-hhmmss");
    private final List<AutoCloseable> controllers = new ArrayList<AutoCloseable>();
    private final String idPrefix;
    private final AtomicInteger instanceIndex;
    private final Map<String, Collection<InstanceId>> nodeToInstanceId = new HashMap<String, Collection<InstanceId>>();
    private final ConfigurationContext configurationContext;
    private Agent localAgent;
    private transient RemoteAgentLauncher remoteAgentLauncher;
    private InstanceId monitorInstanceId;
    private Map<String, String> agentsInstance = new HashMap<String, String>();
    private final int igniteDiscoveryPort;
    private final int igniteComPort;
    private final PortAllocator portAllocator;

    public ClusterFactory(String idPrefix, ConfigurationContext configurationContext) {
        this(idPrefix, configurationContext, (PortAllocator)new DefaultPortAllocator());
    }

    public ClusterFactory(String idPrefix, ConfigurationContext configurationContext, PortAllocator portAllocator) {
        this.idPrefix = idPrefix + "-" + LocalDateTime.now(ZoneId.of("UTC")).format(PATH_FORMAT);
        this.instanceIndex = new AtomicInteger();
        this.configurationContext = configurationContext;
        this.remoteAgentLauncher = configurationContext.remoting().buildRemoteAgentLauncher();
        this.portAllocator = portAllocator;
        PortAllocator.PortReservation reservation = portAllocator.reserve(2);
        this.igniteDiscoveryPort = (Integer)reservation.next();
        this.igniteComPort = (Integer)reservation.next();
        this.localAgent = new Agent();
        this.localAgent.startCluster(Collections.singleton("localhost:" + this.igniteDiscoveryPort), "localhost:" + this.igniteDiscoveryPort, this.igniteDiscoveryPort, this.igniteComPort);
        this.agentsInstance.put("localhost", "localhost:" + this.igniteDiscoveryPort);
    }

    private InstanceId init(String type, Collection<String> hostnames) {
        if (hostnames.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize with 0 server");
        }
        InstanceId instanceId = new InstanceId(this.idPrefix + "-" + this.instanceIndex.getAndIncrement(), type);
        for (String hostname : hostnames) {
            if (hostname == null) {
                throw new IllegalArgumentException("Cannot initialize with a null server name");
            }
            if (IpUtils.isLocal((String)hostname) || this.agentsInstance.containsKey(hostname)) continue;
            String nodeName = hostname + ":" + this.igniteDiscoveryPort;
            StringBuilder addressesToDiscover = new StringBuilder();
            for (String agentAddress : this.agentsInstance.values()) {
                addressesToDiscover.append(agentAddress).append(",");
            }
            if (addressesToDiscover.length() > 0) {
                addressesToDiscover.deleteCharAt(addressesToDiscover.length() - 1);
            }
            this.remoteAgentLauncher.remoteStartAgentOn(hostname, nodeName, this.igniteDiscoveryPort, this.igniteComPort, addressesToDiscover.toString());
            this.agentsInstance.put(hostname, nodeName);
        }
        logger.info("Agents instance (size = {}) : ", (Object)this.agentsInstance.values().size());
        this.agentsInstance.values().forEach(value -> logger.info("- agent instance : {}", value));
        return instanceId;
    }

    public Cluster cluster() {
        if (this.localAgent.getIgnite() == null) {
            throw new IllegalStateException("No cluster component started");
        }
        return new Cluster(this.localAgent.getIgnite());
    }

    public Tsa tsa() {
        TsaConfigurationContext tsaConfigurationContext = this.configurationContext.tsa();
        InstanceId instanceId = this.init(TSA, tsaConfigurationContext.getTopology().getServersHostnames());
        Tsa tsa = new Tsa(this.localAgent.getIgnite(), this.igniteDiscoveryPort, this.portAllocator, instanceId, tsaConfigurationContext);
        this.controllers.add(tsa);
        return tsa;
    }

    public Tms tms() {
        TmsConfigurationContext tmsConfigurationContext = this.configurationContext.tms();
        InstanceId instanceId = this.init(TMS, Collections.singletonList(tmsConfigurationContext.getHostname()));
        Tms tms = new Tms(this.localAgent.getIgnite(), this.igniteDiscoveryPort, instanceId, tmsConfigurationContext);
        this.controllers.add(tms);
        return tms;
    }

    public Voter voter() {
        VoterConfigurationContext voterConfigurationContext = this.configurationContext.voter();
        InstanceId instanceId = this.init(VOTER, voterConfigurationContext.getHostNames());
        Voter voter = new Voter(this.localAgent.getIgnite(), this.igniteDiscoveryPort, instanceId, voterConfigurationContext);
        this.controllers.add(voter);
        return voter;
    }

    public ClientArray clientArray() {
        ClientArrayConfigurationContext clientArrayConfigurationContext = this.configurationContext.clientArray();
        this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        ClientArray clientArray = new ClientArray(this.localAgent.getIgnite(), this.igniteDiscoveryPort, () -> this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames()), clientArrayConfigurationContext);
        this.controllers.add(clientArray);
        return clientArray;
    }

    public ClusterMonitor monitor() {
        MonitoringConfigurationContext monitoringConfigurationContext = this.configurationContext.monitoring();
        if (monitoringConfigurationContext == null) {
            throw new IllegalStateException("MonitoringConfigurationContext has not been registered");
        }
        Map<HardwareMetric, MonitoringCommand> commands = monitoringConfigurationContext.commands();
        Set<String> hostnames = this.configurationContext.allHostnames();
        if (this.monitorInstanceId == null) {
            this.monitorInstanceId = this.init(MONITOR, hostnames);
            ClusterMonitor clusterMonitor = new ClusterMonitor(this.localAgent.getIgnite(), this.igniteDiscoveryPort, this.monitorInstanceId, hostnames, commands);
            this.controllers.add(clusterMonitor);
            return clusterMonitor;
        }
        return new ClusterMonitor(this.localAgent.getIgnite(), this.igniteDiscoveryPort, this.monitorInstanceId, hostnames, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (AutoCloseable controller : this.controllers) {
                try {
                    controller.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.add(e);
                }
            }
            this.controllers.clear();
            this.nodeToInstanceId.clear();
            this.monitorInstanceId = null;
            try {
                this.remoteAgentLauncher.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptions.add(e);
            }
            this.remoteAgentLauncher = null;
            if (this.localAgent != null) {
                try {
                    logger.info("shutting down local agent");
                    this.localAgent.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.add(e);
                }
                this.localAgent = null;
            }
            if (!exceptions.isEmpty()) {
                IOException ioException = new IOException("Error while closing down Cluster Factory prefixed with " + this.idPrefix);
                exceptions.forEach(ioException::addSuppressed);
                throw ioException;
            }
        }
        finally {
            this.portAllocator.close();
        }
    }
}

