/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.support.hamcrest;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.terracotta.angela.client.support.junit.NodeOutputRule;
import org.terracotta.angela.common.ToolExecutionResult;

public class AngelaMatchers {
    public static Matcher<NodeOutputRule.NodeLog> containsLog(final String text) {
        return new CustomTypeSafeMatcher<NodeOutputRule.NodeLog>("contains " + text){

            protected boolean matchesSafely(NodeOutputRule.NodeLog result) {
                return result.streamLogsDescending().anyMatch(line -> line.contains(text));
            }
        };
    }

    public static Matcher<ToolExecutionResult> successful() {
        return new CustomTypeSafeMatcher<ToolExecutionResult>("successful"){

            protected boolean matchesSafely(ToolExecutionResult result) {
                return result.getExitStatus() == 0 && AngelaMatchers.find(result.getOutput(), "successful");
            }
        };
    }

    public static Matcher<ToolExecutionResult> containsOutput(final String text) {
        return new CustomTypeSafeMatcher<ToolExecutionResult>("contains " + text){

            protected boolean matchesSafely(ToolExecutionResult result) {
                return AngelaMatchers.find(result.getOutput(), text);
            }
        };
    }

    public static Matcher<ToolExecutionResult> containsLinesInOrderStartingWith(final Collection<String> expectedLines) {
        return new CustomTypeSafeMatcher<ToolExecutionResult>("contains lines in order starting with:\n" + String.join((CharSequence)"\n", expectedLines)){

            protected boolean matchesSafely(ToolExecutionResult result) {
                LinkedList lines = new LinkedList(expectedLines);
                for (String out : result.getOutput()) {
                    if (!out.startsWith((String)lines.getFirst())) continue;
                    lines.removeFirst();
                }
                return lines.isEmpty();
            }

            protected void describeMismatchSafely(ToolExecutionResult result, Description mismatchDescription) {
                LinkedList lines = new LinkedList(expectedLines);
                for (String out : result.getOutput()) {
                    if (!out.startsWith((String)lines.getFirst())) continue;
                    lines.removeFirst();
                }
                mismatchDescription.appendText("these lines were not found:\n" + String.join((CharSequence)"\n", lines) + "\n in output:\n" + String.join((CharSequence)"\n", result.getOutput()));
            }
        };
    }

    public static Matcher<ToolExecutionResult> containsLinesStartingWith(final Collection<String> expectedLines) {
        return new CustomTypeSafeMatcher<ToolExecutionResult>("contains lines starting with:\n" + String.join((CharSequence)"\n", expectedLines)){

            protected boolean matchesSafely(ToolExecutionResult result) {
                LinkedList<String> lines = new LinkedList<String>(expectedLines);
                for (String out : result.getOutput()) {
                    if (lines.isEmpty()) break;
                    lines.removeIf(out::startsWith);
                }
                return lines.isEmpty();
            }

            protected void describeMismatchSafely(ToolExecutionResult result, Description mismatchDescription) {
                LinkedList<String> lines = new LinkedList<String>(expectedLines);
                for (String out : result.getOutput()) {
                    if (lines.isEmpty()) break;
                    lines.removeIf(out::startsWith);
                }
                mismatchDescription.appendText("these lines were not found:\n" + String.join((CharSequence)"\n", lines) + "\n in output:\n" + String.join((CharSequence)"\n", result.getOutput()));
            }
        };
    }

    public static Matcher<ToolExecutionResult> hasExitStatus(final int exitStatus) {
        return new CustomTypeSafeMatcher<ToolExecutionResult>(" exist status " + exitStatus){

            protected boolean matchesSafely(ToolExecutionResult result) {
                return result.getExitStatus() == exitStatus;
            }
        };
    }

    private static boolean find(List<String> lines, String text) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            if (!lines.get(i).contains(text)) continue;
            return true;
        }
        return false;
    }
}

