/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;

public abstract class Tool
implements AutoCloseable {
    protected final Tsa tsa;

    public Tool(Tsa tsa) {
        this.tsa = tsa;
    }

    @Override
    public void close() {
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }

    public abstract ToolExecutionResult executeCommand(String ... var1);

    protected abstract void install();

    protected abstract void uninstall();

    protected Map<ServerSymbolicName, Integer> updateToProxiedPorts() {
        return this.tsa.getDisruptionController().updateTsaPortsWithProxy(this.tsa.getTsaConfigurationContext().getTopology(), this.tsa.getPortAllocator());
    }

    protected Map<ServerSymbolicName, Integer> getProxyGroupPortsForServer(TerracottaServer terracottaServer) {
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.getProxyGroupPortsForServer(this.tsa.getInstanceId(), terracottaServer);
        return (Map)IgniteClientHelper.executeRemotely(this.tsa.getIgnite(), terracottaServer.getHostname(), this.tsa.getIgnitePort(), callable);
    }
}

