/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.support.junit;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.Voter;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.support.junit.ExtendedTestRule;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.TerracottaServer;

public class AngelaRule
extends ExtendedTestRule {
    private final PortAllocator portAllocator = new DefaultPortAllocator();
    private final ConfigurationContext configuration;
    private final boolean autoStart;
    private final boolean autoActivate;
    private ClusterFactory clusterFactory;
    private Supplier<Tsa> tsa;
    private Supplier<Cluster> cluster;
    private Supplier<Tms> tms;
    private Supplier<ClientArray> clientArray;
    private Supplier<ClusterMonitor> clusterMonitor;
    private Supplier<Voter> voter;
    private Supplier<ConfigTool> configTool;

    public AngelaRule(ConfigurationContext configuration, boolean autoStart, boolean autoActivate) {
        this.configuration = configuration;
        this.autoStart = autoStart;
        this.autoActivate = autoActivate;
    }

    @Override
    protected void before(Description description) throws Throwable {
        int nodePortCount = this.computeNodePortCount();
        PortAllocator.PortReservation nodePortReservation = this.portAllocator.reserve(nodePortCount);
        for (TerracottaServer node : this.configuration.tsa().getTopology().getServers()) {
            if (node.getTsaPort() <= 0) {
                node.tsaPort(((Integer)nodePortReservation.next()).intValue());
            }
            if (node.getTsaGroupPort() > 0) continue;
            node.tsaGroupPort(((Integer)nodePortReservation.next()).intValue());
        }
        int hash = description.getMethodName() == null ? 0 : description.getMethodName().hashCode();
        this.clusterFactory = new ClusterFactory(description.getTestClass().getSimpleName() + "-" + hash, this.configuration);
        this.tsa = AngelaRule.memoize(this.clusterFactory::tsa);
        this.cluster = AngelaRule.memoize(this.clusterFactory::cluster);
        this.tms = AngelaRule.memoize(this.clusterFactory::tms);
        this.clientArray = AngelaRule.memoize(this.clusterFactory::clientArray);
        this.clusterMonitor = AngelaRule.memoize(this.clusterFactory::monitor);
        this.voter = AngelaRule.memoize(this.clusterFactory::voter);
        this.configTool = AngelaRule.memoize(this.clusterFactory::configTool);
        if (this.autoStart) {
            this.startNodes();
            if (this.autoActivate) {
                this.configTool().attachAll();
                this.configTool().activate();
            }
        }
    }

    @Override
    protected void after(Description description) throws Throwable {
        ArrayList<Throwable> errs = new ArrayList<Throwable>(0);
        try {
            if (this.clusterFactory != null) {
                this.clusterFactory.close();
                this.clusterFactory = null;
            }
        }
        catch (Throwable e) {
            errs.add(e);
        }
        try {
            this.portAllocator.close();
        }
        catch (Throwable e) {
            errs.add(e);
        }
        MultipleFailureException.assertEmpty(errs);
    }

    public void startNodes() {
        List stripes = this.configuration.tsa().getTopology().getStripes();
        for (int stripeId = 1; stripeId <= stripes.size(); ++stripeId) {
            List stripe = (List)stripes.get(stripeId - 1);
            for (int nodeId = 1; nodeId <= stripe.size(); ++nodeId) {
                this.startNode(stripeId, nodeId);
            }
        }
    }

    public void startNode(int stripeId, int nodeId) {
        this.startNode(this.getNode(stripeId, nodeId), new String[0]);
    }

    public void startNode(int stripeId, int nodeId, String ... cli) {
        this.startNode(this.getNode(stripeId, nodeId), cli);
    }

    public void startNode(TerracottaServer node, String ... cli) {
        this.tsa().start(node, cli);
    }

    public void stopNode(int stripeId, int nodeId) {
        this.tsa().stop(this.getNode(stripeId, nodeId));
    }

    public ClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public ConfigurationContext getConfiguration() {
        return this.configuration;
    }

    public int getStripeCount() {
        return this.configuration.tsa().getTopology().getStripes().size();
    }

    public int getNodeCount(int stripeId) {
        return this.getStripe(stripeId).size();
    }

    public List<TerracottaServer> getStripe(int stripeId) {
        if (stripeId < 1) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId);
        }
        List stripes = this.configuration.tsa().getTopology().getStripes();
        if (stripeId > stripes.size()) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId + ". There are " + stripes.size() + " stripe(s).");
        }
        return (List)stripes.get(stripeId - 1);
    }

    public TerracottaServer getNode(int stripeId, int nodeId) {
        if (nodeId < 1) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId);
        }
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        if (nodeId > nodes.size()) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId + ". Stripe ID: " + stripeId + " has " + nodes.size() + " nodes.");
        }
        return nodes.get(nodeId - 1);
    }

    public int getNodePort(int stripeId, int nodeId) {
        return this.getNode(stripeId, nodeId).getTsaPort();
    }

    public int getNodeGroupPort(int stripeId, int nodeId) {
        return this.getNode(stripeId, nodeId).getTsaGroupPort();
    }

    public OptionalInt findActive(int stripeId) {
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        return IntStream.rangeClosed(1, nodes.size()).filter(nodeId -> this.tsa().getState((TerracottaServer)nodes.get(nodeId - 1)) == TerracottaServerState.STARTED_AS_ACTIVE).findFirst();
    }

    public int[] findPassives(int stripeId) {
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        return IntStream.rangeClosed(1, nodes.size()).filter(nodeId -> this.tsa().getState((TerracottaServer)nodes.get(nodeId - 1)) == TerracottaServerState.STARTED_AS_PASSIVE).toArray();
    }

    public Tsa tsa() {
        return this.tsa.get();
    }

    public ConfigTool configTool() {
        return this.configTool.get();
    }

    public Cluster cluster() {
        return this.cluster.get();
    }

    public Tms tms() {
        return this.tms.get();
    }

    public ClientArray clientArray() {
        return this.clientArray.get();
    }

    public ClusterMonitor monitor() {
        return this.clusterMonitor.get();
    }

    public Voter voter() {
        return this.voter.get();
    }

    protected int computeNodePortCount() {
        List nodes = this.configuration.tsa().getTopology().getServers();
        return (int)IntStream.concat(nodes.stream().mapToInt(TerracottaServer::getTsaPort), nodes.stream().mapToInt(TerracottaServer::getTsaGroupPort)).filter(port -> port <= 0).count();
    }

    private static <T> Supplier<T> memoize(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T t;

            @Override
            public T get() {
                if (this.t == null) {
                    this.t = supplier.get();
                }
                return this.t;
            }
        };
    }
}

