/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.TmsHttpClient;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tms.security.config.TmsClientSecurityConfig;
import org.terracotta.angela.common.tms.security.config.TmsServerSecurityConfig;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.HostPort;

public class Tms
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Tsa.class);
    private final int ignitePort;
    private final TmsConfigurationContext tmsConfigurationContext;
    private boolean closed = false;
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final LocalKitManager localKitManager;
    @Deprecated
    private static final String NONE = "none";
    @Deprecated
    private static final String BROWSER_SECURITY = "browser-security";
    @Deprecated
    private static final String CLUSTER_SECURITY = "cluster-security";
    @Deprecated
    public static final String FULL = "full";

    Tms(Ignite ignite, int ignitePort, InstanceId instanceId, TmsConfigurationContext tmsConfigurationContext) {
        this.ignitePort = ignitePort;
        this.tmsConfigurationContext = tmsConfigurationContext;
        this.instanceId = instanceId;
        this.ignite = ignite;
        this.localKitManager = new LocalKitManager(tmsConfigurationContext.getDistribution());
        this.install();
    }

    public TmsConfigurationContext getTmsConfigurationContext() {
        return this.tmsConfigurationContext;
    }

    public String url() {
        boolean isHttps = false;
        TmsServerSecurityConfig tmsServerSecurityConfig = this.tmsConfigurationContext.getSecurityConfig();
        if (tmsServerSecurityConfig != null) {
            isHttps = "true".equals(tmsServerSecurityConfig.getTmsSecurityHttpsEnabled()) || FULL.equals(tmsServerSecurityConfig.getDeprecatedSecurityLevel()) || BROWSER_SECURITY.equals(tmsServerSecurityConfig.getDeprecatedSecurityLevel());
        }
        return (isHttps ? "https://" : "http://") + new HostPort(this.tmsConfigurationContext.getHostname(), 9480).getHostPort();
    }

    public TmsHttpClient httpClient() {
        return this.httpClient(null);
    }

    public TmsHttpClient httpClient(TmsClientSecurityConfig tmsClientSecurityConfig) {
        return new TmsHttpClient(this.url(), tmsClientSecurityConfig);
    }

    public RemoteFolder browse(String root) {
        String tmsHostname = this.tmsConfigurationContext.getHostname();
        String path = (String)IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, (IgniteCallable & Serializable)() -> Agent.controller.getTmsInstallationPath(this.instanceId));
        return new RemoteFolder(this.ignite, tmsHostname, this.ignitePort, path, root);
    }

    public TerracottaManagementServerState getTmsState() {
        return (TerracottaManagementServerState)IgniteClientHelper.executeRemotely(this.ignite, this.tmsConfigurationContext.getHostname(), this.ignitePort, (IgniteCallable & Serializable)() -> Agent.controller.getTmsState(this.instanceId));
    }

    public Tms start() {
        return this.start(Collections.emptyMap());
    }

    public Tms start(Map<String, String> envOverrides) {
        String tmsHostname = this.tmsConfigurationContext.getHostname();
        logger.info("Starting TMS on {}", (Object)tmsHostname);
        IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.startTms(this.instanceId, envOverrides));
        return this;
    }

    public void stop() {
        this.stopTms(this.tmsConfigurationContext.getHostname());
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }

    private void uninstall() {
        String tmsHostname = this.tmsConfigurationContext.getHostname();
        TerracottaManagementServerState terracottaServerState = this.getTmsState();
        if (terracottaServerState == null) {
            return;
        }
        if (terracottaServerState != TerracottaManagementServerState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: server " + tmsHostname + " already in state " + terracottaServerState);
        }
        logger.info("Uninstalling TMS from {}", (Object)tmsHostname);
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.uninstallTms(this.instanceId, this.tmsConfigurationContext.getDistribution(), this.tmsConfigurationContext.getSecurityConfig(), this.localKitManager.getKitInstallationName(), tmsHostname, kitInstallationPath));
    }

    private void install() {
        boolean isRemoteInstallationSuccessful;
        String tmsHostname = this.tmsConfigurationContext.getHostname();
        License license = this.tmsConfigurationContext.getLicense();
        Distribution distribution = this.tmsConfigurationContext.getDistribution();
        TmsServerSecurityConfig tmsServerSecurityConfig = this.tmsConfigurationContext.getSecurityConfig();
        TerracottaCommandLineEnvironment tcEnv = this.tmsConfigurationContext.getTerracottaCommandLineEnvironment();
        logger.info("starting TMS on {}", (Object)tmsHostname);
        logger.debug("Setting up locally the extracted install to be deployed remotely");
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        logger.info("Attempting to remotely install if distribution already exists on {}", (Object)tmsHostname);
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.installTms(this.instanceId, tmsHostname, distribution, license, tmsServerSecurityConfig, this.localKitManager.getKitInstallationName(), tcEnv, this.tmsConfigurationContext.getHostname(), kitInstallationPath);
        boolean bl = isRemoteInstallationSuccessful = kitInstallationPath == null && (Boolean)IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, callable) != false;
        if (!isRemoteInstallationSuccessful) {
            try {
                IgniteClientHelper.uploadKit(this.ignite, tmsHostname, this.ignitePort, this.instanceId, distribution, this.localKitManager.getKitInstallationName(), this.localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + tmsHostname, e);
            }
        }
    }

    private void stopTms(String tmsHostname) {
        TerracottaManagementServerState terracottaManagementServerState = this.getTmsState();
        if (terracottaManagementServerState == TerracottaManagementServerState.STOPPED) {
            return;
        }
        if (terracottaManagementServerState != TerracottaManagementServerState.STARTED) {
            throw new IllegalStateException("Cannot stop: TMS server , already in state " + terracottaManagementServerState);
        }
        logger.info("Stopping TMS on {}", (Object)tmsHostname);
        IgniteClientHelper.executeRemotely(this.ignite, tmsHostname, this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.stopTms(this.instanceId));
    }
}

