/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class ClusterTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterTool.class);
    private final InstanceId instanceId;
    private final int ignitePort;
    private final Ignite ignite;
    private final ToolConfigurationContext configContext;
    private final LocalKitManager localKitManager;
    private final Tsa tsa;

    ClusterTool(Ignite ignite, InstanceId instanceId, int ignitePort, ToolConfigurationContext configContext, Tsa tsa) {
        this.instanceId = instanceId;
        this.ignitePort = ignitePort;
        this.ignite = ignite;
        this.configContext = configContext;
        this.localKitManager = new LocalKitManager(configContext.getDistribution());
        this.tsa = tsa;
        this.install();
    }

    public ToolExecutionResult executeCommand(String ... command) {
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.clusterTool(this.instanceId, command);
        return (ToolExecutionResult)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
    }

    public void configure() {
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        TerracottaServer terracottaServer = (TerracottaServer)topology.getConfigurationManager().getServers().get(0);
        logger.info("Configuring cluster from {}", (Object)terracottaServer.getHostname());
        String clusterName = this.tsa.getTsaConfigurationContext().getClusterName();
        if (clusterName == null) {
            clusterName = this.instanceId.toString();
        }
        String licensePath = this.tsa.licensePath(terracottaServer);
        File tmpConfigDir = new File(FileUtils.getTempDirectory(), "tmp-tc-configs");
        if (!tmpConfigDir.mkdir() && !tmpConfigDir.isDirectory()) {
            throw new RuntimeException("Error creating temporary cluster tool TC config folder : " + tmpConfigDir);
        }
        ConfigurationManager configurationProvider = topology.getConfigurationManager();
        TcConfigManager tcConfigProvider = (TcConfigManager)configurationProvider;
        List tcConfigs = tcConfigProvider.getTcConfigs();
        ArrayList<TcConfig> modifiedConfigs = new ArrayList<TcConfig>();
        for (TcConfig tcConfig : tcConfigs) {
            TcConfig modifiedConfig = TcConfig.copy((TcConfig)tcConfig);
            if (topology.isNetDisruptionEnabled()) {
                modifiedConfig.updateServerTsaPort(this.tsa.updateToProxiedPorts());
            }
            modifiedConfig.writeTcConfigFile(tmpConfigDir);
            modifiedConfigs.add(modifiedConfig);
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("configure", "-n", clusterName, "-l", licensePath));
        for (TcConfig tcConfig : modifiedConfigs) {
            command.add(tcConfig.getPath());
        }
        this.executeCommand(command.toArray(new String[0]));
    }

    public void install() {
        boolean isRemoteInstallationSuccessful;
        Distribution distribution = this.configContext.getDistribution();
        License license = this.configContext.getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.installClusterTool(this.instanceId, this.configContext.getHostName(), distribution, license, this.localKitManager.getKitInstallationName(), securityRootDirectory, tcEnv);
        boolean bl = isRemoteInstallationSuccessful = kitInstallationPath == null && (Boolean)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable) != false;
        if (!isRemoteInstallationSuccessful) {
            try {
                IgniteClientHelper.uploadKit(this.ignite, this.configContext.getHostName(), this.ignitePort, this.instanceId, distribution, this.localKitManager.getKitInstallationName(), this.localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + this.configContext.getHostName(), e);
            }
        }
    }

    public void uninstall() {
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> Agent.controller.uninstallClusterTool(this.instanceId, this.configContext.getDistribution(), this.configContext.getHostName(), this.localKitManager.getKitInstallationName());
        IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, uninstaller);
    }

    @Override
    public void close() {
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }
}

