/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolException;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class ConfigTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigTool.class);
    private final int ignitePort;
    private final ToolConfigurationContext configContext;
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final LocalKitManager localKitManager;
    private final Tsa tsa;

    ConfigTool(Ignite ignite, InstanceId instanceId, int ignitePort, ToolConfigurationContext configContext, Tsa tsa) {
        this.ignite = ignite;
        this.instanceId = instanceId;
        this.ignitePort = ignitePort;
        this.configContext = configContext;
        this.localKitManager = new LocalKitManager(configContext.getDistribution());
        this.tsa = tsa;
        this.install();
    }

    public ToolExecutionResult executeCommand(String ... arguments) {
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.configTool(this.instanceId, arguments);
        return (ToolExecutionResult)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
    }

    public void attachStripe(TerracottaServer ... newServers) {
        ArrayList<String> command;
        if (newServers == null || newServers.length == 0) {
            throw new IllegalArgumentException("Servers list should be non-null and non-empty");
        }
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        for (TerracottaServer terracottaServer : newServers) {
            this.tsa.install(terracottaServer, topology);
            this.tsa.start(terracottaServer, new String[0]);
        }
        topology.addStripe(newServers);
        if (newServers.length > 1) {
            command = new ArrayList<String>();
            command.add("attach");
            command.add("-t");
            command.add("node");
            command.add("-d");
            command.add(newServers[0].getHostPort());
            for (int i = 1; i < newServers.length; ++i) {
                command.add("-s");
                command.add(newServers[i].getHostPort());
            }
            ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
            if (result.getExitStatus() != 0) {
                throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
            }
        }
        command = new ArrayList();
        command.add("attach");
        command.add("-t");
        command.add("stripe");
        List stripes = topology.getStripes();
        TerracottaServer existingServer = (TerracottaServer)((List)stripes.get(0)).get(0);
        command.add("-d");
        command.add(existingServer.getHostPort());
        for (TerracottaServer newServer : newServers) {
            command.add("-s");
            command.add(newServer.getHostPort());
        }
        ToolExecutionResult toolExecutionResult = this.executeCommand(command.toArray(new String[0]));
        if (toolExecutionResult.getExitStatus() != 0) {
            throw new ToolException("attach stripe failed", String.join((CharSequence)". ", toolExecutionResult.getOutput()), toolExecutionResult.getExitStatus());
        }
    }

    public void detachStripe(int stripeIndex) {
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        List stripes = topology.getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        if (stripes.size() == 1) {
            throw new IllegalArgumentException("Cannot delete the only stripe from cluster");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("detach");
        command.add("-t");
        command.add("stripe");
        List toDetachStripe = (List)stripes.remove(stripeIndex);
        TerracottaServer destination = (TerracottaServer)((List)stripes.get(0)).get(0);
        command.add("-d");
        command.add(destination.getHostPort());
        command.add("-s");
        command.add(((TerracottaServer)toDetachStripe.get(0)).getHostPort());
        ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new ToolException("detach stripe failed", String.join((CharSequence)". ", result.getOutput()), result.getExitStatus());
        }
        topology.removeStripe(stripeIndex);
    }

    public void attachNode(int stripeIndex, TerracottaServer newServer) {
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        List stripes = topology.getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        if (newServer == null) {
            throw new IllegalArgumentException("Server should be non-null");
        }
        this.tsa.install(newServer, topology);
        this.tsa.start(newServer, new String[0]);
        topology.addServer(stripeIndex, newServer);
        ArrayList<String> command = new ArrayList<String>();
        command.add("attach");
        command.add("-t");
        command.add("node");
        TerracottaServer existingServer = (TerracottaServer)((List)stripes.get(stripeIndex)).get(0);
        command.add("-d");
        command.add(existingServer.getHostPort());
        command.add("-s");
        command.add(newServer.getHostPort());
        ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new ToolException("attach node failed", String.join((CharSequence)". ", result.getOutput()), result.getExitStatus());
        }
    }

    public void detachNode(int stripeIndex, int serverIndex) {
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        List stripes = topology.getStripes();
        if (stripeIndex < -1 || stripeIndex >= stripes.size()) {
            throw new IllegalArgumentException("stripeIndex should be a non-negative integer less than stripe count");
        }
        List servers = (List)stripes.remove(stripeIndex);
        if (serverIndex < -1 || serverIndex >= servers.size()) {
            throw new IllegalArgumentException("serverIndex should be a non-negative integer less than server count");
        }
        TerracottaServer toDetach = (TerracottaServer)servers.remove(serverIndex);
        if (servers.size() == 0 && stripes.size() == 0) {
            throw new IllegalArgumentException("Cannot delete the only server from the cluster");
        }
        TerracottaServer destination = stripes.size() != 0 ? (TerracottaServer)((List)stripes.get(0)).get(0) : (TerracottaServer)servers.get(0);
        ArrayList<String> command = new ArrayList<String>();
        command.add("detach");
        command.add("-t");
        command.add("node");
        command.add("-d");
        command.add(destination.getHostPort());
        command.add("-s");
        command.add(toDetach.getHostPort());
        ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
        if (result.getExitStatus() != 0) {
            throw new ToolException("detach node failed", String.join((CharSequence)". ", result.getOutput()), result.getExitStatus());
        }
        topology.removeServer(stripeIndex, serverIndex);
    }

    public void attachAll() {
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        if (topology.isNetDisruptionEnabled()) {
            for (TerracottaServer terracottaServer : topology.getServers()) {
                this.setClientToServerDisruptionLinks(terracottaServer);
            }
        }
        List stripes = topology.getStripes();
        for (List stripe : stripes) {
            if (stripe.size() <= 1) continue;
            for (int i = 1; i < stripe.size(); ++i) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("attach");
                command.add("-t");
                command.add("node");
                command.add("-d");
                command.add(((TerracottaServer)stripe.get(0)).getHostPort());
                command.add("-s");
                command.add(((TerracottaServer)stripe.get(i)).getHostPort());
                ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
                if (result.getExitStatus() == 0) continue;
                throw new ToolException("attach failed", String.join((CharSequence)". ", result.getOutput()), result.getExitStatus());
            }
        }
        if (stripes.size() > 1) {
            for (int i = 1; i < stripes.size(); ++i) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("attach");
                command.add("-t");
                command.add("stripe");
                command.add("-d");
                command.add(((TerracottaServer)((List)stripes.get(0)).get(0)).getHostPort());
                List stripe = (List)stripes.get(i);
                command.add("-s");
                command.add(((TerracottaServer)stripe.get(0)).getHostPort());
                ToolExecutionResult result = this.executeCommand(command.toArray(new String[0]));
                if (result.getExitStatus() == 0) continue;
                throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + result);
            }
        }
        if (topology.isNetDisruptionEnabled()) {
            for (int i = 1; i <= stripes.size(); ++i) {
                if (((List)stripes.get(i - 1)).size() <= 1) continue;
                this.setServerToServerDisruptionLinks(i, ((List)stripes.get(i - 1)).size());
            }
        }
    }

    public void activate() {
        ToolExecutionResult result;
        TerracottaServer terracottaServer = (TerracottaServer)this.tsa.getTsaConfigurationContext().getTopology().getServers().get(0);
        logger.info("Activating cluster from {}", (Object)terracottaServer.getHostname());
        String clusterName = this.tsa.getTsaConfigurationContext().getClusterName();
        if (clusterName == null) {
            clusterName = this.instanceId.toString();
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("activate", "-n", clusterName, "-s", terracottaServer.getHostPort()));
        String licensePath = this.tsa.licensePath(terracottaServer);
        if (licensePath != null) {
            args.add("-l");
            args.add(licensePath);
        }
        if ((result = this.executeCommand(args.toArray(new String[0]))).getExitStatus() != 0) {
            throw new ToolException("activate failed", String.join((CharSequence)". ", result.getOutput()), result.getExitStatus());
        }
    }

    public void install() {
        boolean isRemoteInstallationSuccessful;
        Distribution distribution = this.configContext.getDistribution();
        License license = this.configContext.getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.installConfigTool(this.instanceId, this.configContext.getHostName(), distribution, license, this.localKitManager.getKitInstallationName(), securityRootDirectory, tcEnv);
        boolean bl = isRemoteInstallationSuccessful = kitInstallationPath == null && (Boolean)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable) != false;
        if (!isRemoteInstallationSuccessful) {
            try {
                IgniteClientHelper.uploadKit(this.ignite, this.configContext.getHostName(), this.ignitePort, this.instanceId, distribution, this.localKitManager.getKitInstallationName(), this.localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + this.configContext.getHostName(), e);
            }
        }
    }

    public void uninstall() {
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> Agent.controller.uninstallConfigTool(this.instanceId, this.configContext.getDistribution(), this.configContext.getHostName(), this.localKitManager.getKitInstallationName());
        IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, uninstaller);
    }

    public void setClientToServerDisruptionLinks(TerracottaServer terracottaServer) {
        ArrayList<String> arguments = new ArrayList<String>();
        String property = "stripe.1.node.1.tc-properties.l2.l1redirect.enabled=false";
        arguments.add("set");
        arguments.add("-s");
        arguments.add(terracottaServer.getHostPort());
        arguments.add("-c");
        arguments.add(property);
        ToolExecutionResult executionResult = this.executeCommand(arguments.toArray(new String[0]));
        if (executionResult.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + executionResult);
        }
        Map<ServerSymbolicName, Integer> proxyMap = this.tsa.updateToProxiedPorts();
        int proxyPort = proxyMap.get(terracottaServer.getServerSymbolicName());
        String publicHostName = "stripe.1.node.1.public-hostname=" + terracottaServer.getHostName();
        String publicPort = "stripe.1.node.1.public-port=" + proxyPort;
        ArrayList<String> args = new ArrayList<String>();
        args.add("set");
        args.add("-s");
        args.add(terracottaServer.getHostPort());
        args.add("-c");
        args.add(publicHostName);
        args.add("-c");
        args.add(publicPort);
        executionResult = this.executeCommand(args.toArray(new String[0]));
        if (executionResult.getExitStatus() != 0) {
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + executionResult);
        }
    }

    public void setServerToServerDisruptionLinks(int stripeId, int size) {
        List stripeServerList = (List)this.tsa.getTsaConfigurationContext().getTopology().getStripes().get(stripeId - 1);
        for (int j = 0; j < size; ++j) {
            TerracottaServer server = (TerracottaServer)stripeServerList.get(j);
            Map<ServerSymbolicName, Integer> proxyGroupPortMapping = this.tsa.getProxyGroupPortsForServer(server);
            int nodeId = j + 1;
            StringBuilder propertyBuilder = new StringBuilder();
            propertyBuilder.append("stripe.").append(stripeId).append(".node.").append(nodeId).append(".tc-properties.test-proxy-group-port=");
            propertyBuilder.append("\"");
            for (Map.Entry<ServerSymbolicName, Integer> entry : proxyGroupPortMapping.entrySet()) {
                propertyBuilder.append(entry.getKey().getSymbolicName());
                propertyBuilder.append("->");
                propertyBuilder.append(entry.getValue());
                propertyBuilder.append("#");
            }
            propertyBuilder.deleteCharAt(propertyBuilder.lastIndexOf("#"));
            propertyBuilder.append("\"");
            ToolExecutionResult executionResult = this.executeCommand("set", "-s", server.getHostPort(), "-c", propertyBuilder.toString());
            if (executionResult.getExitStatus() == 0) continue;
            throw new RuntimeException("ConfigTool::executeCommand with command parameters failed with: " + executionResult);
        }
    }

    @Override
    public void close() {
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }
}

