/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.config.custom;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;

public class CustomVoterConfigurationContext
implements VoterConfigurationContext {
    private final List<TerracottaVoter> terracottaVoters = new ArrayList<TerracottaVoter>();
    private TerracottaCommandLineEnvironment commandLineEnv = TerracottaCommandLineEnvironment.DEFAULT;
    private SecurityRootDirectory securityRootDirectory;
    private Distribution distribution;
    private License license;

    protected CustomVoterConfigurationContext() {
    }

    public CustomVoterConfigurationContext addVoter(TerracottaVoter terracottaVoter) {
        this.terracottaVoters.add(terracottaVoter);
        return this;
    }

    public CustomVoterConfigurationContext securityRootDirectory(Path securityDir) {
        this.securityRootDirectory = SecurityRootDirectory.securityRootDirectory((Path)securityDir);
        return this;
    }

    public CustomVoterConfigurationContext distribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public CustomVoterConfigurationContext license(License license) {
        this.license = license;
        return this;
    }

    public void commandLineEnv(TerracottaCommandLineEnvironment commandLineEnv) {
        this.commandLineEnv = commandLineEnv;
    }

    @Override
    public Distribution getDistribution() {
        return this.distribution;
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    @Override
    public TerracottaCommandLineEnvironment commandLineEnv() {
        return this.commandLineEnv;
    }

    @Override
    public List<TerracottaVoter> getTerracottaVoters() {
        return this.terracottaVoters;
    }

    @Override
    public SecurityRootDirectory getSecurityRootDirectory() {
        return this.securityRootDirectory;
    }

    @Override
    public List<String> getHostNames() {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (TerracottaVoter terracottaVoter : this.terracottaVoters) {
            hostNames.add(terracottaVoter.getHostName());
        }
        return hostNames;
    }
}

