/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.ignite.Ignite;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;

public class ClusterAgent
implements AutoCloseable {
    private final Agent localAgent;
    private final int igniteDiscoveryPort;
    private final int igniteComPort;
    private final PortAllocator portAllocator = new DefaultPortAllocator();

    public ClusterAgent(boolean localOnly) {
        this.localAgent = new Agent();
        if (localOnly) {
            this.igniteDiscoveryPort = 0;
            this.igniteComPort = 0;
            this.localAgent.startLocalCluster();
        } else {
            PortAllocator.PortReservation reservation = this.portAllocator.reserve(2);
            this.igniteDiscoveryPort = (Integer)reservation.next();
            this.igniteComPort = (Integer)reservation.next();
            this.localAgent.startCluster(Collections.singleton("localhost:" + this.igniteDiscoveryPort), "localhost:" + this.igniteDiscoveryPort, this.igniteDiscoveryPort, this.igniteComPort);
        }
    }

    public int getIgniteDiscoveryPort() {
        return this.igniteDiscoveryPort;
    }

    public int getIgniteComPort() {
        return this.igniteComPort;
    }

    public Ignite getIgnite() {
        return this.localAgent.getIgnite();
    }

    public PortAllocator getPortAllocator() {
        return this.portAllocator;
    }

    @Override
    public void close() throws IOException {
        try {
            this.localAgent.close();
        }
        finally {
            this.portAllocator.close();
        }
    }
}

