/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.topology.InstanceId;

public class ClusterTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterTool.class);
    private final InstanceId instanceId;
    private final int ignitePort;
    private final Ignite ignite;
    private final ToolConfigurationContext configContext;
    private final LocalKitManager localKitManager;
    private final Tsa tsa;

    ClusterTool(Ignite ignite, InstanceId instanceId, int ignitePort, ToolConfigurationContext configContext, Tsa tsa) {
        this.instanceId = instanceId;
        this.ignitePort = ignitePort;
        this.ignite = ignite;
        this.configContext = configContext;
        this.localKitManager = new LocalKitManager(configContext.getDistribution());
        this.tsa = tsa;
        this.install();
    }

    public ToolExecutionResult executeCommand(String ... arguments) {
        return this.executeCommand(Collections.emptyMap(), arguments);
    }

    public ToolExecutionResult executeCommand(Map<String, String> env, String ... command) {
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.clusterTool(this.instanceId, env, command);
        return (ToolExecutionResult)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
    }

    public ClusterTool configure(Map<String, String> env) {
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        License license = this.tsa.getTsaConfigurationContext().getLicense();
        String clusterName = this.tsa.getTsaConfigurationContext().getClusterName();
        if (clusterName == null) {
            clusterName = this.instanceId.toString();
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("configure", "-n", clusterName));
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.configure(this.instanceId, this.tsa.getTsaConfigurationContext().getTopology(), this.tsa.updateToProxiedPorts(), license, securityRootDirectory, tcEnv, env, command);
        ToolExecutionResult result = (ToolExecutionResult)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
        if (result.getExitStatus() != 0) {
            throw new IllegalStateException("Failed to execute cluster-tool configure:\n" + result.toString());
        }
        return this;
    }

    public ClusterTool configure() {
        return this.configure(Collections.emptyMap());
    }

    public ClusterTool install() {
        Distribution distribution = this.configContext.getDistribution();
        License license = this.tsa.getTsaConfigurationContext().getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.installClusterTool(this.instanceId, this.configContext.getHostName(), distribution, license, this.localKitManager.getKitInstallationName(), securityRootDirectory, tcEnv, kitInstallationPath);
        boolean isRemoteInstallationSuccessful = (Boolean)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
        if (!(isRemoteInstallationSuccessful || kitInstallationPath != null && AngelaProperties.KIT_COPY.getBooleanValue())) {
            try {
                IgniteClientHelper.uploadKit(this.ignite, this.configContext.getHostName(), this.ignitePort, this.instanceId, distribution, this.localKitManager.getKitInstallationName(), this.localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + this.configContext.getHostName(), e);
            }
        }
        return this;
    }

    public ClusterTool uninstall() {
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> Agent.controller.uninstallClusterTool(this.instanceId, this.configContext.getDistribution(), this.configContext.getHostName(), this.localKitManager.getKitInstallationName());
        IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, uninstaller);
        return this;
    }

    public RemoteFolder browse(String root) {
        String path = (String)IgniteClientHelper.executeRemotely(this.ignite, this.configContext.getHostName(), this.ignitePort, (IgniteCallable & Serializable)() -> Agent.controller.getClusterToolInstallPath(this.instanceId));
        return new RemoteFolder(this.ignite, this.configContext.getHostName(), this.ignitePort, path, root);
    }

    @Override
    public void close() {
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }
}

