/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.client.util.IgniteClientHelper;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.topology.InstanceId;

public class Voter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Voter.class);
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final int ignitePort;
    private final VoterConfigurationContext voterConfigurationContext;
    private final LocalKitManager localKitManager;
    private boolean closed = false;

    Voter(Ignite ignite, int ignitePort, InstanceId instanceId, VoterConfigurationContext voterConfigurationContext) {
        this.ignitePort = ignitePort;
        this.voterConfigurationContext = voterConfigurationContext;
        this.instanceId = instanceId;
        this.ignite = ignite;
        this.localKitManager = new LocalKitManager(voterConfigurationContext.getDistribution());
        this.installAll();
    }

    private void installAll() {
        List<TerracottaVoter> terracottaVoters = this.voterConfigurationContext.getTerracottaVoters();
        for (TerracottaVoter terracottaVoter : terracottaVoters) {
            this.install(terracottaVoter);
        }
    }

    public TerracottaVoterState getTerracottaVoterState(TerracottaVoter terracottaVoter) {
        return (TerracottaVoterState)IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, (IgniteCallable & Serializable)() -> Agent.controller.getVoterState(this.instanceId, terracottaVoter));
    }

    public Voter startAll() {
        this.voterConfigurationContext.getTerracottaVoters().stream().map(voter -> CompletableFuture.runAsync(() -> this.start((TerracottaVoter)voter))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public Voter start(TerracottaVoter terracottaVoter) {
        IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.startVoter(this.instanceId, terracottaVoter));
        return this;
    }

    public Voter stopAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TerracottaVoter terracottaVoter : this.voterConfigurationContext.getTerracottaVoters()) {
            try {
                this.stop(terracottaVoter);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping all voters");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public Voter stop(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState == TerracottaVoterState.STOPPED) {
            return this;
        }
        logger.info("Stopping Voter on {}", (Object)terracottaVoter.getHostName());
        IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.controller.stopVoter(this.instanceId, terracottaVoter));
        return this;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopAll();
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstallAll();
        }
    }

    private void install(TerracottaVoter terracottaVoter) {
        this.installWithKitManager(terracottaVoter);
    }

    private void installWithKitManager(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState != TerracottaVoterState.NOT_INSTALLED) {
            throw new IllegalStateException("Cannot install: voter " + terracottaVoter.getId() + " in state " + terracottaVoterState);
        }
        Distribution distribution = this.voterConfigurationContext.getDistribution();
        License license = this.voterConfigurationContext.getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.voterConfigurationContext.commandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.voterConfigurationContext.getSecurityRootDirectory();
        logger.info("starting voter on {}", (Object)terracottaVoter.getHostName());
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> Agent.controller.installVoter(this.instanceId, terracottaVoter, distribution, license, this.localKitManager.getKitInstallationName(), securityRootDirectory, tcEnv);
        boolean isRemoteInstallationSuccessful = (Boolean)IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, callable);
        if (!(isRemoteInstallationSuccessful || kitInstallationPath != null && AngelaProperties.KIT_COPY.getBooleanValue())) {
            try {
                IgniteClientHelper.uploadKit(this.ignite, terracottaVoter.getHostName(), this.ignitePort, this.instanceId, distribution, this.localKitManager.getKitInstallationName(), this.localKitManager.getKitInstallationPath().toFile());
                IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + terracottaVoter.getHostName(), e);
            }
        }
    }

    private void uninstallAll() {
        for (TerracottaVoter terracottaVoter : this.voterConfigurationContext.getTerracottaVoters()) {
            this.uninstall(terracottaVoter);
        }
    }

    private void uninstall(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState == null) {
            return;
        }
        if (terracottaVoterState != TerracottaVoterState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: voter " + terracottaVoter.getId() + " in state " + terracottaVoterState);
        }
        logger.info("Uninstalling voter from {}", (Object)terracottaVoter.getHostName());
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> Agent.controller.uninstallVoter(this.instanceId, this.voterConfigurationContext.getDistribution(), terracottaVoter, this.localKitManager.getKitInstallationName());
        IgniteClientHelper.executeRemotely(this.ignite, terracottaVoter.getHostName(), this.ignitePort, uninstaller);
    }
}

