/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.ClusterTool;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.Voter;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.MonitoringConfigurationContext;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.client.remote.agent.RemoteAgentLauncher;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.IpUtils;

public class ClusterFactory
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFactory.class);
    private static final String TSA = "tsa";
    private static final String TMS = "tms";
    private static final String CLIENT_ARRAY = "clientArray";
    private static final String MONITOR = "monitor";
    private static final String CLUSTER_TOOL = "clusterTool";
    private static final String CONFIG_TOOL = "configTool";
    private static final String VOTER = "voter";
    private static final DateTimeFormatter PATH_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-hhmmssSSS");
    private final List<AutoCloseable> controllers = new ArrayList<AutoCloseable>();
    private final Agent localAgent;
    private final PortAllocator portAllocator;
    private final String idPrefix;
    private final AtomicInteger instanceIndex;
    private final Map<String, String> agentsInstance = new HashMap<String, String>();
    private final ConfigurationContext configurationContext;
    private transient RemoteAgentLauncher remoteAgentLauncher;
    private InstanceId monitorInstanceId;

    ClusterFactory(Agent agent, PortAllocator portAllocator, String idPrefix, ConfigurationContext configurationContext) {
        this.idPrefix = idPrefix + "-" + LocalDateTime.now(ZoneId.of("UTC")).format(PATH_FORMAT);
        this.instanceIndex = new AtomicInteger();
        this.configurationContext = configurationContext;
        this.remoteAgentLauncher = configurationContext.remoting().buildRemoteAgentLauncher();
        this.localAgent = agent;
        this.portAllocator = portAllocator;
        this.agentsInstance.put("localhost", "localhost:" + this.localAgent.getIgniteDiscoveryPort());
    }

    private InstanceId init(String type, Collection<String> hostnames) {
        if (hostnames.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize with 0 server");
        }
        InstanceId instanceId = new InstanceId(this.idPrefix + "-" + this.instanceIndex.getAndIncrement(), type);
        for (String hostname : hostnames) {
            if (hostname == null) {
                throw new IllegalArgumentException("Cannot initialize with a null server name");
            }
            if (IpUtils.isLocal((String)hostname) || this.agentsInstance.containsKey(hostname)) continue;
            String nodeName = hostname + ":" + this.localAgent.getIgniteDiscoveryPort();
            StringBuilder addressesToDiscover = new StringBuilder();
            for (String agentAddress : this.agentsInstance.values()) {
                addressesToDiscover.append(agentAddress).append(",");
            }
            if (addressesToDiscover.length() > 0) {
                addressesToDiscover.deleteCharAt(addressesToDiscover.length() - 1);
            }
            this.remoteAgentLauncher.remoteStartAgentOn(hostname, nodeName, this.localAgent.getIgniteDiscoveryPort(), this.localAgent.getIgniteComPort(), addressesToDiscover.toString());
            this.agentsInstance.put(hostname, nodeName);
        }
        logger.info("Agents instance (size = {}) : ", (Object)this.agentsInstance.values().size());
        this.agentsInstance.values().forEach(value -> logger.info("- agent instance : {}", value));
        return instanceId;
    }

    public Cluster cluster() {
        if (this.localAgent.getIgnite() == null) {
            throw new IllegalStateException("No cluster component started");
        }
        return new Cluster(this.localAgent.getIgnite());
    }

    public Tsa tsa() {
        TsaConfigurationContext tsaConfigurationContext = this.configurationContext.tsa();
        if (tsaConfigurationContext == null) {
            throw new IllegalArgumentException("tsa() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(TSA, tsaConfigurationContext.getTopology().getServersHostnames());
        Tsa tsa = new Tsa(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), this.portAllocator, instanceId, tsaConfigurationContext);
        this.controllers.add(tsa);
        return tsa;
    }

    public Tms tms() {
        TmsConfigurationContext tmsConfigurationContext = this.configurationContext.tms();
        if (tmsConfigurationContext == null) {
            throw new IllegalArgumentException("tms() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(TMS, Collections.singletonList(tmsConfigurationContext.getHostname()));
        Tms tms = new Tms(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), instanceId, tmsConfigurationContext);
        this.controllers.add(tms);
        return tms;
    }

    public ClusterTool clusterTool() {
        ToolConfigurationContext clusterToolConfigurationContext = this.configurationContext.clusterTool();
        if (clusterToolConfigurationContext == null) {
            throw new IllegalArgumentException("clusterTool() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(CLUSTER_TOOL, Collections.singleton(clusterToolConfigurationContext.getHostName()));
        Tsa tsa = this.controllers.stream().filter(controller -> controller instanceof Tsa).map(autoCloseable -> (Tsa)autoCloseable).findAny().orElseThrow(() -> new IllegalStateException("Tsa should be defined before cluster tool in ConfigurationContext"));
        ClusterTool clusterTool = new ClusterTool(this.localAgent.getIgnite(), instanceId, this.localAgent.getIgniteDiscoveryPort(), clusterToolConfigurationContext, tsa);
        this.controllers.add(clusterTool);
        return clusterTool;
    }

    public ConfigTool configTool() {
        ToolConfigurationContext configToolConfigurationContext = this.configurationContext.configTool();
        if (configToolConfigurationContext == null) {
            throw new IllegalArgumentException("configTool() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(CONFIG_TOOL, Collections.singleton(configToolConfigurationContext.getHostName()));
        Tsa tsa = this.controllers.stream().filter(controller -> controller instanceof Tsa).map(autoCloseable -> (Tsa)autoCloseable).findAny().orElseThrow(() -> new IllegalStateException("Tsa should be defined before config tool in ConfigurationContext"));
        ConfigTool configTool = new ConfigTool(this.localAgent.getIgnite(), instanceId, this.localAgent.getIgniteDiscoveryPort(), configToolConfigurationContext, tsa);
        this.controllers.add(configTool);
        return configTool;
    }

    public Voter voter() {
        VoterConfigurationContext voterConfigurationContext = this.configurationContext.voter();
        if (voterConfigurationContext == null) {
            throw new IllegalArgumentException("voter() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(VOTER, voterConfigurationContext.getHostNames());
        Voter voter = new Voter(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), instanceId, voterConfigurationContext);
        this.controllers.add(voter);
        return voter;
    }

    public ClientArray clientArray() {
        ClientArrayConfigurationContext clientArrayConfigurationContext = this.configurationContext.clientArray();
        if (clientArrayConfigurationContext == null) {
            throw new IllegalArgumentException("clientArray() configuration missing in the ConfigurationContext");
        }
        this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        ClientArray clientArray = new ClientArray(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), () -> this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames()), clientArrayConfigurationContext);
        this.controllers.add(clientArray);
        return clientArray;
    }

    public ClusterMonitor monitor() {
        MonitoringConfigurationContext monitoringConfigurationContext = this.configurationContext.monitoring();
        if (monitoringConfigurationContext == null) {
            throw new IllegalArgumentException("monitoring() configuration missing in the ConfigurationContext");
        }
        Map<HardwareMetric, MonitoringCommand> commands = monitoringConfigurationContext.commands();
        Set<String> hostnames = this.configurationContext.allHostnames();
        if (this.monitorInstanceId == null) {
            this.monitorInstanceId = this.init(MONITOR, hostnames);
            ClusterMonitor clusterMonitor = new ClusterMonitor(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), this.monitorInstanceId, hostnames, commands);
            this.controllers.add(clusterMonitor);
            return clusterMonitor;
        }
        return new ClusterMonitor(this.localAgent.getIgnite(), this.localAgent.getIgniteDiscoveryPort(), this.monitorInstanceId, hostnames, commands);
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AutoCloseable controller : this.controllers) {
            try {
                controller.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptions.add(e);
            }
        }
        this.controllers.clear();
        this.monitorInstanceId = null;
        try {
            this.remoteAgentLauncher.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            exceptions.add(e);
        }
        this.remoteAgentLauncher = null;
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error while closing down Cluster Factory prefixed with " + this.idPrefix);
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }
}

