/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.config.custom;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContextVisitor;
import org.terracotta.angela.client.config.MonitoringConfigurationContext;
import org.terracotta.angela.client.config.RemotingConfigurationContext;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomClientArrayConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomClusterToolConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomConfigToolConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomMonitoringConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomRemotingConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomTmsConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomTsaConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomVoterConfigurationContext;
import org.terracotta.angela.client.remote.agent.SshRemoteAgentLauncher;
import org.terracotta.angela.common.distribution.Distribution;

public class CustomConfigurationContext
implements ConfigurationContext {
    private CustomRemotingConfigurationContext customRemotingConfigurationContext = new CustomRemotingConfigurationContext().remoteAgentLauncherSupplier(SshRemoteAgentLauncher::new);
    private CustomTsaConfigurationContext customTsaConfigurationContext;
    private CustomTmsConfigurationContext customTmsConfigurationContext;
    private CustomMonitoringConfigurationContext customMonitoringConfigurationContext;
    private CustomClientArrayConfigurationContext customClientArrayConfigurationContext;
    private CustomVoterConfigurationContext customVoterConfigurationContext;
    private CustomClusterToolConfigurationContext customClusterToolConfigurationContext;
    private CustomConfigToolConfigurationContext customConfigToolConfigurationContext;

    public static CustomConfigurationContext customConfigurationContext() {
        return new CustomConfigurationContext();
    }

    protected CustomConfigurationContext() {
    }

    @Override
    public void visit(ConfigurationContextVisitor visitor) {
        if (this.customTsaConfigurationContext != null) {
            visitor.visit(this.customTsaConfigurationContext);
        }
    }

    @Override
    public RemotingConfigurationContext remoting() {
        return this.customRemotingConfigurationContext;
    }

    public CustomConfigurationContext remoting(CustomRemotingConfigurationContext customRemotingConfigurationContext) {
        this.customRemotingConfigurationContext = customRemotingConfigurationContext;
        return this;
    }

    @Override
    public TsaConfigurationContext tsa() {
        return this.customTsaConfigurationContext;
    }

    public CustomConfigurationContext tsa(Consumer<CustomTsaConfigurationContext> tsa) {
        if (this.customTsaConfigurationContext != null) {
            throw new IllegalStateException("TSA config already defined");
        }
        this.customTsaConfigurationContext = new CustomTsaConfigurationContext();
        tsa.accept(this.customTsaConfigurationContext);
        if (this.customTsaConfigurationContext.getTopology() == null) {
            throw new IllegalArgumentException("You added a tsa to the Configuration but did not define its topology");
        }
        if (this.customTsaConfigurationContext.getLicense() == null && !this.customTsaConfigurationContext.getTopology().getLicenseType().isOpenSource()) {
            throw new IllegalArgumentException("LicenseType " + this.customTsaConfigurationContext.getTopology().getLicenseType() + " requires a license.");
        }
        return this;
    }

    @Override
    public TmsConfigurationContext tms() {
        return this.customTmsConfigurationContext;
    }

    public CustomConfigurationContext tms(Consumer<CustomTmsConfigurationContext> tms) {
        if (this.customTmsConfigurationContext != null) {
            throw new IllegalStateException("TMS config already defined");
        }
        this.customTmsConfigurationContext = new CustomTmsConfigurationContext();
        tms.accept(this.customTmsConfigurationContext);
        if (this.customTmsConfigurationContext.getLicense() == null) {
            throw new IllegalArgumentException("TMS requires a license.");
        }
        return this;
    }

    @Override
    public ClientArrayConfigurationContext clientArray() {
        return this.customClientArrayConfigurationContext;
    }

    public CustomConfigurationContext clientArray(Consumer<CustomClientArrayConfigurationContext> clientArray) {
        if (this.customClientArrayConfigurationContext != null) {
            throw new IllegalStateException("client array config already defined");
        }
        this.customClientArrayConfigurationContext = new CustomClientArrayConfigurationContext();
        clientArray.accept(this.customClientArrayConfigurationContext);
        Distribution distribution = this.customClientArrayConfigurationContext.getClientArrayTopology().getDistribution();
        if (this.customClientArrayConfigurationContext.getLicense() == null && distribution != null && !distribution.getLicenseType().isOpenSource()) {
            throw new IllegalArgumentException("Distribution's license type '" + distribution.getLicenseType() + "' requires a license.");
        }
        return this;
    }

    @Override
    public Set<String> allHostnames() {
        HashSet<String> hostnames = new HashSet<String>();
        if (this.customTsaConfigurationContext != null) {
            hostnames.addAll(this.customTsaConfigurationContext.getTopology().getServersHostnames());
        }
        if (this.customTmsConfigurationContext != null) {
            hostnames.add(this.customTmsConfigurationContext.getHostname());
        }
        if (this.customClientArrayConfigurationContext != null) {
            hostnames.addAll(this.customClientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        }
        return hostnames;
    }

    @Override
    public MonitoringConfigurationContext monitoring() {
        return this.customMonitoringConfigurationContext;
    }

    @Override
    public ToolConfigurationContext clusterTool() {
        return this.customClusterToolConfigurationContext;
    }

    @Override
    public ToolConfigurationContext configTool() {
        return this.customConfigToolConfigurationContext;
    }

    @Override
    public VoterConfigurationContext voter() {
        return this.customVoterConfigurationContext;
    }

    public CustomConfigurationContext clusterTool(Consumer<CustomClusterToolConfigurationContext> clusterTool) {
        if (this.customClusterToolConfigurationContext != null) {
            throw new IllegalStateException("Cluster tool config already defined");
        }
        this.customClusterToolConfigurationContext = new CustomClusterToolConfigurationContext();
        clusterTool.accept(this.customClusterToolConfigurationContext);
        return this;
    }

    public CustomConfigurationContext configTool(Consumer<CustomConfigToolConfigurationContext> configTool) {
        if (this.customConfigToolConfigurationContext != null) {
            throw new IllegalStateException("Config tool config already defined");
        }
        this.customConfigToolConfigurationContext = new CustomConfigToolConfigurationContext();
        configTool.accept(this.customConfigToolConfigurationContext);
        return this;
    }

    public CustomConfigurationContext voter(Consumer<CustomVoterConfigurationContext> voter) {
        if (this.customVoterConfigurationContext != null) {
            throw new IllegalStateException("Voter config already defined");
        }
        this.customVoterConfigurationContext = new CustomVoterConfigurationContext();
        voter.accept(this.customVoterConfigurationContext);
        return this;
    }

    public CustomConfigurationContext monitoring(Consumer<CustomMonitoringConfigurationContext> consumer) {
        if (this.customMonitoringConfigurationContext != null) {
            throw new IllegalStateException("Monitoring config already defined");
        }
        this.customMonitoringConfigurationContext = new CustomMonitoringConfigurationContext();
        consumer.accept(this.customMonitoringConfigurationContext);
        return this;
    }
}

