/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.config.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContextVisitor;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomClientArrayConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomTmsConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomTsaConfigurationContext;

public class CustomMultiConfigurationContext
extends CustomConfigurationContext {
    private final List<CustomTsaConfigurationContext> customTsaConfigurationContexts = new ArrayList<CustomTsaConfigurationContext>();
    private int customTsaConfigurationContextsIndex = 0;
    private final List<CustomTmsConfigurationContext> customTmsConfigurationContexts = new ArrayList<CustomTmsConfigurationContext>();
    private int customTmsConfigurationContextsIndex = 0;
    private final List<CustomClientArrayConfigurationContext> customClientArrayConfigurationContexts = new ArrayList<CustomClientArrayConfigurationContext>();
    private int customClientArrayConfigurationContextsIndex = 0;

    public static CustomMultiConfigurationContext customMultiConfigurationContext() {
        return new CustomMultiConfigurationContext();
    }

    private CustomMultiConfigurationContext() {
    }

    @Override
    public void visit(ConfigurationContextVisitor visitor) {
        for (CustomTsaConfigurationContext context : this.customTsaConfigurationContexts) {
            visitor.visit(context);
        }
    }

    @Override
    public TsaConfigurationContext tsa() {
        if (this.customTsaConfigurationContextsIndex >= this.customTsaConfigurationContexts.size()) {
            throw new IllegalStateException(this.customTsaConfigurationContexts.size() + " contained TSA configs, but trying to access config #" + this.customTsaConfigurationContextsIndex);
        }
        return this.customTsaConfigurationContexts.get(this.customTsaConfigurationContextsIndex++);
    }

    @Override
    public CustomConfigurationContext tsa(Consumer<CustomTsaConfigurationContext> tsa) {
        CustomTsaConfigurationContext customTsaConfigurationContext = new CustomTsaConfigurationContext();
        this.customTsaConfigurationContexts.add(customTsaConfigurationContext);
        tsa.accept(customTsaConfigurationContext);
        return this;
    }

    @Override
    public TmsConfigurationContext tms() {
        if (this.customTmsConfigurationContextsIndex >= this.customTmsConfigurationContexts.size()) {
            throw new IllegalStateException(this.customTmsConfigurationContexts.size() + " contained TMS configs, but trying to access config #" + this.customTmsConfigurationContextsIndex);
        }
        return this.customTmsConfigurationContexts.get(this.customTmsConfigurationContextsIndex++);
    }

    @Override
    public CustomConfigurationContext tms(Consumer<CustomTmsConfigurationContext> tms) {
        CustomTmsConfigurationContext customTmsConfigurationContext = new CustomTmsConfigurationContext();
        this.customTmsConfigurationContexts.add(customTmsConfigurationContext);
        tms.accept(customTmsConfigurationContext);
        return this;
    }

    @Override
    public ClientArrayConfigurationContext clientArray() {
        if (this.customClientArrayConfigurationContextsIndex >= this.customClientArrayConfigurationContexts.size()) {
            throw new IllegalStateException(this.customClientArrayConfigurationContexts.size() + " contained client array configs, but trying to access config #" + this.customClientArrayConfigurationContextsIndex);
        }
        return this.customClientArrayConfigurationContexts.get(this.customClientArrayConfigurationContextsIndex++);
    }

    @Override
    public CustomConfigurationContext clientArray(Consumer<CustomClientArrayConfigurationContext> clientArray) {
        CustomClientArrayConfigurationContext customClientArrayConfigurationContext = new CustomClientArrayConfigurationContext();
        this.customClientArrayConfigurationContexts.add(customClientArrayConfigurationContext);
        clientArray.accept(customClientArrayConfigurationContext);
        return this;
    }

    @Override
    public Set<String> allHostnames() {
        HashSet<String> hostnames = new HashSet<String>();
        for (CustomTsaConfigurationContext customTsaConfigurationContext : this.customTsaConfigurationContexts) {
            hostnames.addAll(customTsaConfigurationContext.getTopology().getServersHostnames());
        }
        for (CustomTmsConfigurationContext customTmsConfigurationContext : this.customTmsConfigurationContexts) {
            hostnames.add(customTmsConfigurationContext.getHostname());
        }
        for (CustomClientArrayConfigurationContext customClientArrayConfigurationContext : this.customClientArrayConfigurationContexts) {
            hostnames.addAll(customClientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        }
        return hostnames;
    }
}

