/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.remote.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.scp.SCPRemoteException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.remote.agent.RemoteAgentLauncher;
import org.terracotta.angela.client.remote.agent.SshLogOutputStream;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.util.AngelaVersions;
import org.terracotta.angela.common.util.JDK;
import org.terracotta.angela.common.util.JavaLocationResolver;

public class SshRemoteAgentLauncher
implements RemoteAgentLauncher {
    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(SshRemoteAgentLauncher.class);
    private static final int MAX_LINE_LENGTH = 1024;
    private final Map<String, RemoteAgentHolder> clients = new HashMap<String, RemoteAgentHolder>();
    private final String remoteUserName;
    private final String remoteUserNameKeyPath;
    private final TerracottaCommandLineEnvironment tcEnv;
    private File agentJarFile;
    private boolean agentJarFileShouldBeRemoved;

    public SshRemoteAgentLauncher() {
        this(TerracottaCommandLineEnvironment.DEFAULT);
    }

    public SshRemoteAgentLauncher(TerracottaCommandLineEnvironment tcEnv) {
        this.tcEnv = tcEnv;
        this.remoteUserName = AngelaProperties.SSH_USERNAME.getValue();
        this.remoteUserNameKeyPath = AngelaProperties.SSH_USERNAME_KEY_PATH.getValue();
    }

    private void initAgentJar() {
        if (this.agentJarFile != null) {
            return;
        }
        Map.Entry<File, Boolean> agentJar = SshRemoteAgentLauncher.findAgentJarFile();
        this.agentJarFile = agentJar.getKey();
        this.agentJarFileShouldBeRemoved = agentJar.getValue();
        if (this.agentJarFile == null) {
            throw new RuntimeException("agent JAR file not found, cannot use SSH remote agent launcher");
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "REC_CATCH_EXCEPTION"})
    public void remoteStartAgentOn(String hostname, String nodeName, int igniteDiscoveryPort, int igniteComPort, String addressesToDiscover) {
        this.initAgentJar();
        LOGGER.info("spawning {} agent via SSH", (Object)hostname);
        try {
            SSHClient ssh = new SSHClient();
            String angelaHome = ".angela/" + hostname;
            if (!AngelaProperties.SSH_STRICT_HOST_CHECKING.getBooleanValue()) {
                ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            }
            ssh.loadKnownHosts();
            ssh.connect(hostname);
            if (this.remoteUserNameKeyPath == null) {
                ssh.authPublickey(this.remoteUserName);
            } else {
                ssh.authPublickey(this.remoteUserName, new String[]{this.remoteUserNameKeyPath});
            }
            Path baseDir = Agent.ROOT_DIR.resolve(angelaHome);
            Path jarsDir = baseDir.resolve("jars");
            this.exec(ssh, "mkdir -p " + baseDir);
            this.exec(ssh, "chmod a+w " + baseDir.getParent().toString());
            this.exec(ssh, "chmod a+w " + baseDir);
            this.exec(ssh, "mkdir -p " + jarsDir);
            this.exec(ssh, "chmod a+w " + jarsDir);
            if (this.agentJarFile.getName().endsWith("-SNAPSHOT.jar") || this.exec(ssh, "[ -e " + jarsDir.resolve(this.agentJarFile.getName()) + " ]") != 0) {
                LOGGER.info("uploading agent jar {} ...", (Object)this.agentJarFile.getName());
                this.uploadJar(ssh, this.agentJarFile, jarsDir);
            }
            LOGGER.info("looking up remote JDK ...");
            String remoteJavaHome = this.findJavaHomeFromRemoteToolchains(ssh);
            Session session = ssh.startSession();
            session.allocateDefaultPTY();
            LOGGER.info("starting agent");
            Session.Command cmd = session.exec(remoteJavaHome + "/bin/java -D" + AngelaProperties.NODE_NAME.getPropertyName() + "=" + nodeName + " -Dignite.discovery.port=" + igniteDiscoveryPort + " -Dignite.com.port=" + igniteComPort + " -D" + AngelaProperties.DIRECT_JOIN.getPropertyName() + "=" + addressesToDiscover + " -D" + AngelaProperties.ROOT_DIR.getPropertyName() + "=" + baseDir + " -jar " + jarsDir.resolve(this.agentJarFile.getName()));
            SshLogOutputStream sshLogOutputStream = new SshLogOutputStream(hostname, cmd);
            new StreamCopier(cmd.getInputStream(), (OutputStream)((Object)sshLogOutputStream), LoggerFactory.DEFAULT).bufSize(1024).spawnDaemon("stdout");
            new StreamCopier(cmd.getErrorStream(), (OutputStream)((Object)sshLogOutputStream), LoggerFactory.DEFAULT).bufSize(1024).spawnDaemon("stderr");
            sshLogOutputStream.waitForStartedState();
            LOGGER.info("agent started on {}", (Object)hostname);
            this.clients.put(hostname, new RemoteAgentHolder(ssh, session, cmd));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to " + this.remoteUserName + "@" + hostname + " (using SSH)", e);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static Map.Entry<File, Boolean> findAgentJarFile() {
        try {
            if (AngelaVersions.INSTANCE.isSnapshot()) {
                String snapshotLocation = System.getProperty("user.home") + "/.m2/repository/org/terracotta/angela-agent/" + AngelaVersions.INSTANCE.getAngelaVersion() + "/angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar";
                File snapshot = new File(snapshotLocation);
                if (snapshot.isFile()) {
                    LOGGER.info("Found agent jar at " + snapshotLocation);
                    return new AbstractMap.SimpleEntry<File, Boolean>(snapshot, false);
                }
                String mavenBaseDir = System.getProperty("basedir");
                if (mavenBaseDir != null && new File(mavenBaseDir + "/../agent").isDirectory() && (snapshot = new File(snapshotLocation = mavenBaseDir + "/../agent/target/angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar")).isFile()) {
                    LOGGER.info("Found agent jar at " + snapshotLocation);
                    return new AbstractMap.SimpleEntry<File, Boolean>(snapshot, false);
                }
                throw new RuntimeException("Agent SNAPSHOT jar file not found at " + snapshotLocation);
            }
            File tmpDir = Files.createTempDirectory("angela", new FileAttribute[0]).toFile();
            File agentFile = new File(tmpDir, "angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar");
            String releaseUrl = "https://search.maven.org/remotecontent?filepath=org/terracotta/angela-agent/" + AngelaVersions.INSTANCE.getAngelaVersion() + "/angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar";
            URL jarUrl = new URL(releaseUrl);
            try (InputStream jarIs = jarUrl.openStream();
                 FileOutputStream fileOutputStream = new FileOutputStream(agentFile);){
                IOUtils.copy((InputStream)jarIs, (OutputStream)fileOutputStream);
            }
            LOGGER.info("Installed agent jar from Nexus at " + agentFile.getAbsolutePath());
            return new AbstractMap.SimpleEntry<File, Boolean>(agentFile, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get angela-agent jar", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer exec(SSHClient ssh, String line) throws TransportException, ConnectionException {
        try (Session session = ssh.startSession();){
            try (Session.Command cmd = session.exec(line);){
                cmd.join(10L, TimeUnit.SECONDS);
            }
            Integer n = cmd.getExitStatus();
            return n;
        }
    }

    private void uploadJar(SSHClient ssh, File agentJarFile, Path targetFolder) throws IOException {
        String remotePath = targetFolder.resolve(agentJarFile.getName()).toString();
        ssh.newSCPFileTransfer().upload(agentJarFile.getPath(), remotePath);
    }

    private String findJavaHomeFromRemoteToolchains(SSHClient ssh) throws IOException {
        InMemoryDestFile localFile = new InMemoryDestFile(){
            private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

            public OutputStream getOutputStream() {
                return this.baos;
            }
        };
        try {
            ssh.newSCPFileTransfer().download("$HOME/.m2/toolchains.xml", (LocalDestFile)localFile);
        }
        catch (SCPRemoteException sre) {
            throw new RuntimeException("Remote does not have $HOME/.m2/toolchains.xml file");
        }
        byte[] bytes = ((ByteArrayOutputStream)localFile.getOutputStream()).toByteArray();
        JavaLocationResolver javaLocationResolver = new JavaLocationResolver((InputStream)new ByteArrayInputStream(bytes));
        List jdks = javaLocationResolver.resolveJavaLocations(this.tcEnv.getJavaVersion(), this.tcEnv.getJavaVendors(), false);
        for (JDK jdk : jdks) {
            String remoteHome = jdk.getHome();
            if (this.exec(ssh, "[ -d \"" + remoteHome + "\" ]") != 0) continue;
            LOGGER.info("found remote JDK : home='{}' version='{}' vendor='{}'", new Object[]{jdk.getHome(), jdk.getVersion(), jdk.getVendor()});
            return remoteHome;
        }
        throw new RuntimeException("No JDK configured in remote toolchains.xml is valid; wanted : " + this.tcEnv + ", found : " + jdks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void close() {
        if (this.agentJarFileShouldBeRemoved) {
            this.agentJarFile.delete();
        }
        Throwable uioe = null;
        for (Map.Entry<String, RemoteAgentHolder> entry : this.clients.entrySet()) {
            RemoteAgentHolder holder = entry.getValue();
            LOGGER.info("Cleaning up SSH agent on {}", (Object)entry.getKey());
            try {
                OutputStream os = holder.session.getOutputStream();
                os.write(3);
            }
            catch (IOException e) {
                if (uioe == null) {
                    uioe = new UncheckedIOException(e);
                    continue;
                }
                uioe.addSuppressed(e);
            }
            finally {
                SshRemoteAgentLauncher.safeClose((Closeable)holder.command);
                SshRemoteAgentLauncher.safeClose((Closeable)holder.session);
                SshRemoteAgentLauncher.safeClose((Closeable)holder.sshClient);
            }
        }
        this.clients.clear();
        if (uioe != null) {
            throw uioe;
        }
    }

    private static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error while cleaning up SSH agent", (Throwable)e);
        }
    }

    static class RemoteAgentHolder {
        SSHClient sshClient;
        Session session;
        Session.Command command;

        RemoteAgentHolder(SSHClient sshClient, Session session, Session.Command command) {
            this.sshClient = sshClient;
            this.session = session;
            this.command = command;
        }
    }
}

