/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.util.Collections;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContextVisitor;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.topology.Topology;

public class AngelaOrchestrator
implements AutoCloseable {
    private final Agent localAgent;
    private final PortAllocator portAllocator = new DefaultPortAllocator();

    private AngelaOrchestrator(boolean local) {
        if (local) {
            this.localAgent = Agent.startLocalCluster();
        } else {
            PortAllocator.PortReservation reservation = this.portAllocator.reserve(2);
            int igniteDiscoveryPort = (Integer)reservation.next();
            int igniteComPort = (Integer)reservation.next();
            this.localAgent = Agent.startCluster(Collections.singleton("localhost:" + igniteDiscoveryPort), (String)("localhost:" + igniteDiscoveryPort), (int)igniteDiscoveryPort, (int)igniteComPort);
        }
        Agent.setUniqueInstance((Agent)this.localAgent);
    }

    public PortAllocator getPortAllocator() {
        return this.portAllocator;
    }

    public ClusterFactory newClusterFactory(String idPrefix, ConfigurationContext configurationContext) {
        configurationContext.visit(new ConfigurationContextVisitor(){

            @Override
            public void visit(TsaConfigurationContext tsaConfigurationContext) {
                Topology topology = tsaConfigurationContext.getTopology();
                if (topology != null) {
                    topology.init(AngelaOrchestrator.this.portAllocator);
                }
            }
        });
        return new ClusterFactory(this.localAgent, this.portAllocator, idPrefix, configurationContext);
    }

    @Override
    public void close() {
        try {
            this.localAgent.close();
        }
        finally {
            Agent.removeUniqueInstance((Agent)this.localAgent);
            this.portAllocator.close();
        }
    }

    public static AgentOrchestratorBuilder builder() {
        return new AgentOrchestratorBuilder();
    }

    public static class AgentOrchestratorBuilder {
        boolean local = false;

        public AgentOrchestratorBuilder local() {
            this.local = true;
            return this;
        }

        public AngelaOrchestrator build() {
            return new AngelaOrchestrator(this.local);
        }
    }
}

