/*
 * Copyright Terracotta, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.terracotta.angela.client.config;

import java.util.List;
import java.util.Set;

public interface ConfigurationContext {

  void visit(ConfigurationContextVisitor visitor);

  RemotingConfigurationContext remoting();

  TsaConfigurationContext tsa();

  TmsConfigurationContext tms();

  default ClientArrayConfigurationContext firstClientArray() {
    return clientArray().iterator().next();
  }

  default ClientArrayConfigurationContext clientArray(int idx) {
    return clientArray().get(idx);
  }

  List<? extends ClientArrayConfigurationContext> clientArray();

  Set<String> allHostnames();

  MonitoringConfigurationContext monitoring();

  ToolConfigurationContext clusterTool();

  ToolConfigurationContext configTool();

  VoterConfigurationContext voter();
}
