/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContextVisitor;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.IpUtils;

public class AngelaOrchestrator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AngelaOrchestrator.class);
    private final Agent localAgent;
    private final PortAllocator portAllocator = new DefaultPortAllocator();

    private AngelaOrchestrator(boolean local) {
        if (local) {
            this.localAgent = Agent.startLocalCluster();
        } else {
            PortAllocator.PortReservation reservation = this.portAllocator.reserve(2);
            int igniteDiscoveryPort = (Integer)reservation.next();
            int igniteComPort = (Integer)reservation.next();
            this.localAgent = Agent.startCluster(Collections.singleton(IpUtils.getHostName() + ":" + igniteDiscoveryPort), (String)(IpUtils.getHostName() + ":" + igniteDiscoveryPort), (int)igniteDiscoveryPort, (int)igniteComPort);
        }
        Agent.setUniqueInstance((Agent)this.localAgent);
    }

    public PortAllocator getPortAllocator() {
        return this.portAllocator;
    }

    public ClusterFactory newClusterFactory(String idPrefix, final ConfigurationContext configurationContext) {
        configurationContext.visit(new ConfigurationContextVisitor(){

            @Override
            public void visit(TsaConfigurationContext tsaConfigurationContext) {
                Topology topology = tsaConfigurationContext.getTopology();
                if (topology != null) {
                    logger.trace("Allocating ports for servers...");
                    topology.init(AngelaOrchestrator.this.portAllocator);
                }
            }

            @Override
            public void visit(VoterConfigurationContext voterConfigurationContext) {
                for (TerracottaVoter terracottaVoter : voterConfigurationContext.getTerracottaVoters()) {
                    List hostPorts = terracottaVoter.getHostPorts();
                    List serverNames = terracottaVoter.getServerNames();
                    if (hostPorts.isEmpty() && serverNames.isEmpty()) {
                        throw new IllegalArgumentException("Voter incorrectly configured: missing hosts/ports or server names");
                    }
                    if (!hostPorts.isEmpty()) continue;
                    for (String serverName : serverNames) {
                        hostPorts.add(configurationContext.tsa().getTopology().getServers().stream().filter(server -> server.getServerSymbolicName().getSymbolicName().equals(serverName)).findFirst().map(TerracottaServer::getHostPort).orElseThrow(() -> new IllegalArgumentException("Incorrect voter configuration: server name '" + serverName + "' not found")));
                    }
                    logger.trace("Voter configured to connect to: " + hostPorts);
                }
            }
        });
        return new ClusterFactory(this.localAgent, this.portAllocator, idPrefix, configurationContext);
    }

    @Override
    public void close() {
        try {
            this.localAgent.close();
        }
        finally {
            Agent.removeUniqueInstance((Agent)this.localAgent);
            this.portAllocator.close();
        }
    }

    public static AgentOrchestratorBuilder builder() {
        return new AgentOrchestratorBuilder();
    }

    public static class AgentOrchestratorBuilder {
        boolean local = false;

        public AgentOrchestratorBuilder local() {
            this.local = true;
            return this;
        }

        public AngelaOrchestrator build() {
            return new AngelaOrchestrator(this.local);
        }
    }
}

