/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.filesystem.RemoteFile;
import org.terracotta.angela.client.util.IgniteClientHelper;

public class RemoteFolder
extends RemoteFile {
    private final int ignitePort;

    public RemoteFolder(Ignite ignite, String hostname, int ignitePort, String parentName, String name) {
        super(ignite, hostname, ignitePort, parentName, name);
        this.ignitePort = ignitePort;
    }

    public List<RemoteFile> list() {
        String absoluteName = this.getAbsoluteName();
        IgniteCallable & Serializable filesCallable = (IgniteCallable & Serializable)() -> Agent.getInstance().getController().listFiles(absoluteName);
        List remoteFiles = (List)IgniteClientHelper.executeRemotely(this.ignite, this.hostname, this.ignitePort, filesCallable);
        IgniteCallable & Serializable foldersCallable = (IgniteCallable & Serializable)() -> Agent.getInstance().getController().listFolders(absoluteName);
        List remoteFolders = (List)IgniteClientHelper.executeRemotely(this.ignite, this.hostname, this.ignitePort, foldersCallable);
        ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
        result.addAll(remoteFiles.stream().map(s -> new RemoteFile(this.ignite, this.hostname, this.ignitePort, this.getAbsoluteName(), (String)s)).collect(Collectors.toList()));
        result.addAll(remoteFolders.stream().map(s -> new RemoteFolder(this.ignite, this.hostname, this.ignitePort, this.getAbsoluteName(), (String)s)).collect(Collectors.toList()));
        return result;
    }

    public void upload(File localFile) throws IOException {
        if (localFile.isDirectory()) {
            this.uploadFolder(".", localFile);
        } else {
            try (FileInputStream fis = new FileInputStream(localFile);){
                this.upload(localFile.getName(), fis);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void uploadFolder(String parentName, File folder) throws IOException {
        File[] files;
        for (File f : files = folder.listFiles()) {
            String currentName = parentName + "/" + f.getName();
            if (f.isDirectory()) {
                this.uploadFolder(currentName, f);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(f);){
                this.upload(currentName, fis);
            }
        }
    }

    public void upload(String remoteFilename, URL localResourceUrl) throws IOException {
        try (InputStream in = localResourceUrl.openStream();){
            this.upload(remoteFilename, in);
        }
    }

    public void upload(String remoteFilename, InputStream localStream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)localStream);
        String filename = this.getAbsoluteName() + "/" + remoteFilename;
        IgniteClientHelper.executeRemotely(this.ignite, this.hostname, this.ignitePort, (IgniteRunnable & Serializable)() -> Agent.getInstance().getController().uploadFile(filename, data));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void downloadTo(File localPath) throws IOException {
        byte[] bytes;
        String foldername = this.getAbsoluteName();
        try {
            bytes = (byte[])IgniteClientHelper.executeRemotely(this.ignite, this.hostname, this.ignitePort, (IgniteCallable & Serializable)() -> Agent.getInstance().getController().downloadFolder(foldername));
        }
        catch (IgniteException ie) {
            throw new IOException("Error downloading remote folder '" + foldername + "' into local folder '" + localPath + "'", ie);
        }
        localPath.mkdirs();
        if (!localPath.isDirectory()) {
            throw new IllegalArgumentException("Destination path '" + localPath + "' is not a folder or could not be created");
        }
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));){
            while (true) {
                FileOutputStream fos;
                block26: {
                    ZipEntry nextEntry;
                    if ((nextEntry = zis.getNextEntry()) == null) {
                        return;
                    }
                    String name = nextEntry.getName();
                    File file = new File(localPath, name);
                    file.getParentFile().mkdirs();
                    fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)fos);
                        if (fos == null) continue;
                        if (throwable == null) break block26;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "/";
    }
}

