/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.FileMetadata;
import org.terracotta.angela.common.util.IgniteCommonHelper;
import org.terracotta.angela.common.util.IpUtils;

public class IgniteClientHelper {
    private static final Logger logger = LoggerFactory.getLogger(IgniteClientHelper.class);

    public static void executeRemotely(Ignite ignite, String hostname, int ignitePort, IgniteRunnable job) {
        if (ignite == null) {
            IgniteClientHelper.executeLocally(job);
        } else {
            IgniteClientHelper.executeRemotelyAsync(ignite, hostname, ignitePort, job).get();
        }
    }

    private static void executeLocally(IgniteRunnable job) {
        job.run();
    }

    public static IgniteFuture<Void> executeRemotelyAsync(Ignite ignite, String hostname, int ignitePort, IgniteRunnable job) {
        IgniteClientHelper.checkAgentHealth(ignite, hostname, ignitePort);
        logger.debug("Executing job on {}", (Object)IgniteClientHelper.getNodeName(hostname, ignitePort));
        IgniteCommonHelper.displayCluster((Ignite)ignite);
        ClusterGroup location = ignite.cluster().forAttribute("nodename", (Object)IgniteClientHelper.getNodeName(hostname, ignitePort));
        return ignite.compute(location).runAsync(job);
    }

    public static <R> R executeRemotely(Ignite ignite, String hostname, int ignitePort, IgniteCallable<R> job) {
        if (ignite == null) {
            return IgniteClientHelper.executeLocally(job);
        }
        return (R)IgniteClientHelper.executeRemotelyAsync(ignite, hostname, ignitePort, job).get();
    }

    private static <R> R executeLocally(IgniteCallable<R> job) {
        try {
            return (R)job.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> IgniteFuture<R> executeRemotelyAsync(Ignite ignite, String hostname, int ignitePort, IgniteCallable<R> job) {
        IgniteClientHelper.checkAgentHealth(ignite, hostname, ignitePort);
        logger.debug("Executing job on {}", (Object)IgniteClientHelper.getNodeName(hostname, ignitePort));
        ClusterGroup location = ignite.cluster().forAttribute("nodename", (Object)IgniteClientHelper.getNodeName(hostname, ignitePort));
        return ignite.compute(location).callAsync(job);
    }

    private static void checkAgentHealth(Ignite ignite, String hostname, int ignitePort) {
        if (ignite == null) {
            throw new IllegalStateException("No ignite instance");
        }
        String nodeName = IgniteClientHelper.getNodeName(hostname, ignitePort);
        ClusterGroup location = ignite.cluster().forAttribute("nodename", (Object)nodeName);
        IgniteFuture future = ignite.compute(location).broadcastAsync((IgniteCallable & Serializable)() -> Agent.getInstance().getController().getNodeAttributes());
        try {
            Collection attributeMaps = (Collection)future.get(60L, TimeUnit.SECONDS);
            if (attributeMaps.size() != 1) {
                throw new IllegalStateException("Detected " + attributeMaps.size() + " agents with node name [" + nodeName + "] while expected exactly one");
            }
            Map attributeMap = (Map)attributeMaps.iterator().next();
            if (!nodeName.equals(attributeMap.get("nodename"))) {
                throw new IllegalStateException("Agent " + nodeName + " mistakenly identifies itself as " + attributeMap.get("nodename"));
            }
            if (!AngelaVersion.getAngelaVersion().equals(attributeMap.get("angela.version"))) {
                throw new IllegalStateException("Agent " + nodeName + " is running version [" + attributeMap.get("angela.version") + "] but the expected version is [" + AngelaVersion.getAngelaVersion() + "]");
            }
        }
        catch (IgniteException e) {
            throw new IllegalStateException("Node with name '" + nodeName + "' not found in the cluster", e);
        }
    }

    private static String getNodeName(String nodeName, int ignitePort) {
        return (IpUtils.isLocal((String)nodeName) ? IpUtils.getHostName() : nodeName) + ":" + ignitePort;
    }

    public static void uploadKit(Ignite ignite, String hostname, int ignitePort, InstanceId instanceId, Distribution distribution, String kitInstallationName, File kitInstallationPath) throws IOException, InterruptedException {
        IgniteFuture<Void> remoteDownloadFuture = IgniteClientHelper.executeRemotelyAsync(ignite, hostname, ignitePort, (IgniteRunnable & Serializable)() -> {
            RemoteKitManager remoteKitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            File installDir = remoteKitManager.getKitInstallationPath().getParent().toFile();
            Agent.getInstance().getController().downloadFiles(instanceId, installDir);
        });
        IgniteClientHelper.uploadFiles(ignite, instanceId, Collections.singletonList(kitInstallationPath), remoteDownloadFuture);
    }

    public static void uploadClientJars(Ignite ignite, String hostname, int ignitePort, InstanceId instanceId, List<File> filesToUpload) throws IOException, InterruptedException {
        IgniteFuture<Void> remoteDownloadFuture = IgniteClientHelper.executeRemotelyAsync(ignite, hostname, ignitePort, (IgniteRunnable & Serializable)() -> Agent.getInstance().getController().downloadFiles(instanceId, new RemoteClientManager(instanceId).getClientClasspathRoot()));
        IgniteClientHelper.uploadFiles(ignite, instanceId, filesToUpload, remoteDownloadFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFiles(Ignite ignite, InstanceId instanceId, List<File> files, IgniteFuture<Void> remoteDownloadFuture) throws InterruptedException, IOException {
        try {
            BlockingQueue queue = IgniteCommonHelper.fileTransferQueue((Ignite)ignite, (InstanceId)instanceId);
            for (File file : files) {
                IgniteClientHelper.uploadFile(remoteDownloadFuture, queue, file, null);
            }
            queue.put(Boolean.TRUE);
        }
        finally {
            remoteDownloadFuture.get();
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void uploadFile(IgniteFuture<Void> remoteDownloadFuture, BlockingQueue<Object> queue, File file, String path) throws InterruptedException, IOException {
        if (remoteDownloadFuture.isDone()) {
            throw new RuntimeException("Download process failed, cancelling upload");
        }
        FileMetadata fileMetadata = new FileMetadata(path, file);
        if (!file.exists()) {
            logger.debug("skipping upload of non-existent classpath entry {}", (Object)fileMetadata);
            return;
        }
        queue.put(fileMetadata);
        logger.debug("uploading {}", (Object)fileMetadata);
        if (file.isDirectory()) {
            File[] files;
            for (File _file : files = file.listFiles()) {
                String parentPath = path == null ? "" : path + "/";
                IgniteClientHelper.uploadFile(remoteDownloadFuture, queue, _file, parentPath + file.getName());
            }
        } else {
            byte[] buffer = new byte[65536];
            try (FileInputStream fis = new FileInputStream(file);){
                int read;
                while ((read = fis.read(buffer)) >= 0) {
                    byte[] toSend;
                    if (read != buffer.length) {
                        toSend = new byte[read];
                        System.arraycopy(buffer, 0, toSend, 0, read);
                    } else {
                        toSend = buffer;
                    }
                    queue.put(toSend);
                }
            }
            logger.debug("uploaded {}", (Object)fileMetadata);
        }
    }
}

