/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.com.IgniteFutureAdapter;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.JavaBinaries;

public class Client
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final AgentID clientAgentID;
    private final AgentID parentAgentID;
    private final InstanceId instanceId;
    private final ClientId clientId;
    private final transient Executor executor;
    private boolean stopped = false;
    private boolean closed = false;

    private Client(Executor executor, InstanceId instanceId, ClientId clientId, AgentID clientAgentID, AgentID parentAgentID) {
        this.instanceId = instanceId;
        this.clientId = clientId;
        this.executor = executor;
        this.clientAgentID = clientAgentID;
        this.parentAgentID = parentAgentID;
    }

    public AgentID getClientAgentID() {
        return this.clientAgentID;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    int getPid() {
        return this.getClientAgentID().getPid();
    }

    public static Client spawn(Executor executor, InstanceId instanceId, ClientId clientId, ClientArrayConfigurationContext clientArrayConfigurationContext, LocalKitManager localKitManager, TerracottaCommandLineEnvironment tcEnv) {
        AgentID parentAgentID = executor.getAgentID(clientId.getHostName());
        logger.info("Spawning client: {} instance: {} through agent: {}", new Object[]{clientId, instanceId, parentAgentID});
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        localKitManager.setupLocalInstall(clientArrayConfigurationContext.getLicense(), kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        try {
            List<Path> jars = Client.listClasspathFiles(localKitManager);
            for (Path jar : jars) {
                logger.debug("Uploading classpath file : {}", (Object)jar.getFileName());
            }
            executor.uploadClientJars(parentAgentID, instanceId, jars);
            AgentGroup group = executor.getGroup();
            AgentID clientAgentID = (AgentID)executor.execute(parentAgentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().spawnClient(instanceId, tcEnv, group));
            logger.info("Started client: {} instance: {} through agent: {} on agent: {}", new Object[]{clientId, instanceId, parentAgentID, clientAgentID});
            return new Client(executor, instanceId, clientId, clientAgentID, parentAgentID);
        }
        catch (Exception e) {
            logger.error("Cannot create client: {} through: {}: {}", new Object[]{instanceId, parentAgentID, e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    private static List<Path> listClasspathFiles(LocalKitManager localKitManager) {
        ArrayList<File> files = new ArrayList<File>();
        String javaHome = JavaBinaries.jdkHome().orElse(JavaBinaries.javaHome()).toString();
        logger.debug("Skipping all JVM libraries inside {}", (Object)javaHome);
        String[] classpathJarNames = System.getProperty("java.class.path").split(File.pathSeparator);
        boolean substituteClientJars = localKitManager.getDistribution() != null;
        ArrayList<File> libs = new ArrayList<File>();
        for (String classpathJarName : classpathJarNames) {
            if (classpathJarName.startsWith(javaHome)) {
                logger.debug("Skipping {} as it is part of the JVM", (Object)classpathJarName);
                continue;
            }
            File classpathFile = new File(classpathJarName);
            File equivalentClientJar = localKitManager.equivalentClientJar(classpathFile);
            if (substituteClientJars && equivalentClientJar != null) {
                logger.debug("Skipping upload of classpath file as kit contains equivalent jar in client libs : {}", (Object)classpathFile.getName());
                libs.add(equivalentClientJar);
                continue;
            }
            files.add(classpathFile);
        }
        if (substituteClientJars) {
            logger.debug("Enhancing client classpath with client jars of {}", (Object)localKitManager.getDistribution());
            files.addAll(libs);
            logger.debug("Adding clients jars : {}", libs);
        }
        return files.stream().map(File::toPath).collect(Collectors.toList());
    }

    Future<Void> submit(ClientId clientId, ClientJob clientJob) {
        Cluster cluster = this.executor.getCluster(clientId);
        IgniteCallable & Serializable call = (IgniteCallable & Serializable)() -> {
            try {
                clientJob.run(cluster);
                return null;
            }
            catch (Throwable t) {
                throw new IgniteFutureAdapter.RemoteExecutionException("Remote ClientJob failed", Client.exceptionToString(t));
            }
        };
        return this.executor.executeAsync(this.clientAgentID, (IgniteCallable)call);
    }

    private static String exceptionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public RemoteFolder browse(String root) {
        return new RemoteFolder(this.executor.forAgent(this.clientAgentID), null, root);
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String getHostName() {
        return this.getClientId().getHostName();
    }

    public String getSymbolicName() {
        return this.getClientId().getSymbolicName().getSymbolicName();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stop();
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            logger.debug("Wiping up data for client: {} instance: {} started from: {}", new Object[]{this.clientId, this.instanceId, this.parentAgentID});
            this.executor.execute(this.parentAgentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().deleteClient(this.instanceId));
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        logger.info("Killing agent: {} for client:{} instance: {} started from: {}", new Object[]{this.clientAgentID, this.clientId, this.instanceId, this.parentAgentID});
        int pid = this.clientAgentID.getPid();
        this.executor.execute(this.parentAgentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().stopClient(this.instanceId, pid));
    }
}

