/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Client;
import org.terracotta.angela.client.ClientArrayFuture;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.Jcmd;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.topology.InstanceId;

public class ClientArray
implements AutoCloseable {
    private final transient Executor executor;
    private final transient Supplier<InstanceId> clientInstanceIdSupplier;
    private final transient LocalKitManager localKitManager;
    private final transient Map<ClientId, Client> clients = new HashMap<ClientId, Client>();
    private final transient ClientArrayConfigurationContext clientArrayConfigurationContext;
    private boolean closed = false;

    ClientArray(Executor executor, Supplier<InstanceId> clientInstanceIdSupplier, ClientArrayConfigurationContext clientArrayConfigurationContext) {
        this.clientArrayConfigurationContext = clientArrayConfigurationContext;
        this.clientInstanceIdSupplier = clientInstanceIdSupplier;
        this.executor = executor;
        this.localKitManager = new LocalKitManager(clientArrayConfigurationContext.getClientArrayTopology().getDistribution());
        this.installAll();
    }

    private void installAll() {
        this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds().forEach(this::install);
    }

    private Client install(ClientId clientId) {
        InstanceId clientInstanceId = this.clientInstanceIdSupplier.get();
        TerracottaCommandLineEnvironment environment = this.clientArrayConfigurationContext.getTerracottaCommandLineEnvironment();
        Client client = Client.spawn(this.executor, clientInstanceId, clientId, this.clientArrayConfigurationContext, this.localKitManager, environment);
        this.clients.put(clientId, client);
        return client;
    }

    private void uninstallAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            try {
                this.uninstall(clientId);
            }
            catch (Exception ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException ex = new RuntimeException("Error uninstalling some clients");
            exceptions.forEach(ex::addSuppressed);
            throw ex;
        }
    }

    private void uninstall(ClientId clientId) {
        Client client = this.clients.get(clientId);
        try {
            if (client != null) {
                client.close();
            }
        }
        finally {
            this.clients.remove(clientId);
        }
    }

    public Jcmd jcmd(ClientId clientId) {
        return this.jcmd(this.clients.get(clientId));
    }

    public Jcmd jcmd(Client client) {
        TerracottaCommandLineEnvironment tcEnv = this.clientArrayConfigurationContext.getTerracottaCommandLineEnvironment();
        return new Jcmd(this.executor, client, tcEnv);
    }

    public void stopAll() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            try {
                this.stop(clientId);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error stopping some clients");
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }

    public void stop(ClientId clientId) {
        Client client = this.clients.get(clientId);
        if (client != null) {
            client.stop();
        }
    }

    public ClientArrayConfigurationContext getClientArrayConfigurationContext() {
        return this.clientArrayConfigurationContext;
    }

    public ClientArrayFuture executeOnAll(ClientJob clientJob) {
        return this.executeOnAll(clientJob, 1);
    }

    public ClientArrayFuture executeOnAll(ClientJob clientJob, int jobsPerClient) {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (ClientId clientId : this.clientArrayConfigurationContext.getClientArrayTopology().getClientIds()) {
            for (int i = 1; i <= jobsPerClient; ++i) {
                futures.add(this.executeOn(clientId, clientJob));
            }
        }
        return new ClientArrayFuture(futures);
    }

    public Future<Void> executeOn(ClientId clientId, ClientJob clientJob) {
        return this.clients.get(clientId).submit(clientId, clientJob);
    }

    public RemoteFolder browse(Client client, String remoteLocation) {
        InstanceId instanceId = client.getInstanceId();
        AgentID agentID = this.executor.getAgentID(client.getHostName());
        AgentExecutor agentExecutor = this.executor.forAgent(agentID);
        String clientWorkDir = (String)agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().instanceWorkDir(instanceId));
        return new RemoteFolder(agentExecutor, clientWorkDir, remoteLocation);
    }

    public void download(String remoteLocation, File localRootPath) {
        this.download(remoteLocation, localRootPath.toPath());
    }

    public void download(String remoteLocation, Path localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Client client : this.clients.values()) {
            try {
                this.browse(client, remoteLocation).downloadTo(localRootPath.resolve(client.getSymbolicName()));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstallAll();
        }
    }

    public Collection<Client> getClients() {
        return Collections.unmodifiableCollection(this.clients.values());
    }
}

