/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.ClusterTool;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.Voter;
import org.terracotta.angela.client.config.ClientArrayConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.MonitoringConfigurationContext;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.topology.InstanceId;

public class ClusterFactory
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFactory.class);
    private static final String TSA = "tsa";
    private static final String TMS = "tms";
    private static final String CLIENT_ARRAY = "clientArray";
    private static final String MONITOR = "monitor";
    private static final String CLUSTER_TOOL = "clusterTool";
    private static final String CONFIG_TOOL = "configTool";
    private static final String VOTER = "voter";
    private static final DateTimeFormatter PATH_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-hhmmssSSS");
    private final List<AutoCloseable> controllers = new ArrayList<AutoCloseable>();
    private final Executor executor;
    private final PortAllocator portAllocator;
    private final String idPrefix;
    private final AtomicInteger instanceIndex;
    private final ConfigurationContext configurationContext;
    private InstanceId monitorInstanceId;

    ClusterFactory(Executor executor, PortAllocator portAllocator, String idPrefix, ConfigurationContext configurationContext) {
        this.idPrefix = idPrefix + "-" + LocalDateTime.now(ZoneId.of("UTC")).format(PATH_FORMAT);
        this.instanceIndex = new AtomicInteger();
        this.configurationContext = configurationContext;
        this.executor = executor;
        this.portAllocator = portAllocator;
    }

    private synchronized InstanceId init(String type, Collection<String> hostnames) {
        if (hostnames.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize with 0 server");
        }
        if (hostnames.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Cannot initialize with a null server name");
        }
        List agentIDS = hostnames.stream().filter(hostname -> !this.executor.findAgentID(hostname).isPresent()).map(arg_0 -> ((Executor)this.executor).startRemoteAgent(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!agentIDS.isEmpty()) {
            logger.info("Spawned agents: {}", agentIDS);
        }
        return new InstanceId(this.idPrefix + "-" + this.instanceIndex.getAndIncrement(), type);
    }

    public Cluster cluster() {
        return this.executor.getCluster();
    }

    public Tsa tsa() {
        TsaConfigurationContext tsaConfigurationContext = this.configurationContext.tsa();
        if (tsaConfigurationContext == null) {
            throw new IllegalArgumentException("tsa() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(TSA, tsaConfigurationContext.getTopology().getServersHostnames());
        Tsa tsa = new Tsa(this.executor, this.portAllocator, instanceId, tsaConfigurationContext);
        this.controllers.add(tsa);
        return tsa;
    }

    public Tms tms() {
        TmsConfigurationContext tmsConfigurationContext = this.configurationContext.tms();
        if (tmsConfigurationContext == null) {
            throw new IllegalArgumentException("tms() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(TMS, Collections.singletonList(tmsConfigurationContext.getHostName()));
        Tms tms = new Tms(this.executor, instanceId, tmsConfigurationContext);
        this.controllers.add(tms);
        return tms;
    }

    public ClusterTool clusterTool() {
        ToolConfigurationContext clusterToolConfigurationContext = this.configurationContext.clusterTool();
        if (clusterToolConfigurationContext == null) {
            throw new IllegalArgumentException("clusterTool() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(CLUSTER_TOOL, Collections.singleton(clusterToolConfigurationContext.getHostName()));
        Tsa tsa = this.controllers.stream().filter(controller -> controller instanceof Tsa).map(autoCloseable -> (Tsa)autoCloseable).findAny().orElseThrow(() -> new IllegalStateException("Tsa should be defined before cluster tool in ConfigurationContext"));
        ClusterTool clusterTool = new ClusterTool(this.executor, instanceId, clusterToolConfigurationContext, tsa);
        this.controllers.add(clusterTool);
        return clusterTool;
    }

    public ConfigTool configTool() {
        ToolConfigurationContext configToolConfigurationContext = this.configurationContext.configTool();
        if (configToolConfigurationContext == null) {
            throw new IllegalArgumentException("configTool() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(CONFIG_TOOL, Collections.singleton(configToolConfigurationContext.getHostName()));
        Tsa tsa = this.controllers.stream().filter(controller -> controller instanceof Tsa).map(autoCloseable -> (Tsa)autoCloseable).findAny().orElseThrow(() -> new IllegalStateException("Tsa should be defined before config tool in ConfigurationContext"));
        ConfigTool configTool = new ConfigTool(this.executor, instanceId, configToolConfigurationContext, tsa);
        this.controllers.add(configTool);
        return configTool;
    }

    public Voter voter() {
        VoterConfigurationContext voterConfigurationContext = this.configurationContext.voter();
        if (voterConfigurationContext == null) {
            throw new IllegalArgumentException("voter() configuration missing in the ConfigurationContext");
        }
        InstanceId instanceId = this.init(VOTER, voterConfigurationContext.getHostNames());
        Voter voter = new Voter(this.executor, instanceId, voterConfigurationContext);
        this.controllers.add(voter);
        return voter;
    }

    public ClientArray firstClientArray() {
        return this.clientArray(0);
    }

    public ClientArray clientArray(int idx) {
        ClientArrayConfigurationContext clientArrayConfigurationContext = this.configurationContext.clientArray(idx);
        this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
        ClientArray clientArray = new ClientArray(this.executor, () -> this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames()), clientArrayConfigurationContext);
        this.controllers.add(clientArray);
        return clientArray;
    }

    public List<ClientArray> clientArray() {
        return this.configurationContext.clientArray().stream().map(clientArrayConfigurationContext -> {
            this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames());
            ClientArray clientArray = new ClientArray(this.executor, () -> this.init(CLIENT_ARRAY, clientArrayConfigurationContext.getClientArrayTopology().getClientHostnames()), (ClientArrayConfigurationContext)clientArrayConfigurationContext);
            this.controllers.add(clientArray);
            return clientArray;
        }).collect(Collectors.toList());
    }

    public ClusterMonitor monitor() {
        MonitoringConfigurationContext monitoringConfigurationContext = this.configurationContext.monitoring();
        if (monitoringConfigurationContext == null) {
            throw new IllegalArgumentException("monitoring() configuration missing in the ConfigurationContext");
        }
        Map<HardwareMetric, MonitoringCommand> commands = monitoringConfigurationContext.commands();
        Set<String> hostnames = this.configurationContext.allHostnames();
        if (this.monitorInstanceId == null) {
            this.monitorInstanceId = this.init(MONITOR, hostnames);
            ClusterMonitor clusterMonitor = new ClusterMonitor(this.executor, this.monitorInstanceId, hostnames, commands);
            this.controllers.add(clusterMonitor);
            return clusterMonitor;
        }
        return new ClusterMonitor(this.executor, this.monitorInstanceId, hostnames, commands);
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AutoCloseable controller : this.controllers) {
            try {
                controller.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptions.add(e);
            }
        }
        this.controllers.clear();
        this.monitorInstanceId = null;
        if (!exceptions.isEmpty()) {
            IOException ioException = new IOException("Error while closing down Cluster Factory prefixed with " + this.idPrefix);
            exceptions.forEach(ioException::addSuppressed);
            throw ioException;
        }
    }
}

