/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.TmsHttpClient;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.TmsConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tms.security.config.TmsClientSecurityConfig;
import org.terracotta.angela.common.tms.security.config.TmsServerSecurityConfig;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.HostPort;

public class Tms
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Tsa.class);
    private final transient TmsConfigurationContext tmsConfigurationContext;
    private boolean closed = false;
    private final transient Executor executor;
    private final InstanceId instanceId;
    private final transient LocalKitManager localKitManager;
    @Deprecated
    private static final String NONE = "none";
    @Deprecated
    private static final String BROWSER_SECURITY = "browser-security";
    @Deprecated
    private static final String CLUSTER_SECURITY = "cluster-security";
    @Deprecated
    public static final String FULL = "full";

    Tms(Executor executor, InstanceId instanceId, TmsConfigurationContext tmsConfigurationContext) {
        this.tmsConfigurationContext = tmsConfigurationContext;
        this.instanceId = instanceId;
        this.executor = executor;
        this.localKitManager = new LocalKitManager(tmsConfigurationContext.getDistribution());
        this.install();
    }

    public TmsConfigurationContext getTmsConfigurationContext() {
        return this.tmsConfigurationContext;
    }

    public String url() {
        boolean isHttps = false;
        TmsServerSecurityConfig tmsServerSecurityConfig = this.tmsConfigurationContext.getSecurityConfig();
        if (tmsServerSecurityConfig != null) {
            isHttps = "true".equals(tmsServerSecurityConfig.getTmsSecurityHttpsEnabled()) || FULL.equals(tmsServerSecurityConfig.getDeprecatedSecurityLevel()) || BROWSER_SECURITY.equals(tmsServerSecurityConfig.getDeprecatedSecurityLevel());
        }
        return (isHttps ? "https://" : "http://") + new HostPort(this.tmsConfigurationContext.getHostName(), 9480).getHostPort();
    }

    public TmsHttpClient httpClient() {
        return this.httpClient(null);
    }

    public TmsHttpClient httpClient(TmsClientSecurityConfig tmsClientSecurityConfig) {
        return new TmsHttpClient(this.url(), tmsClientSecurityConfig);
    }

    public RemoteFolder browse(String root) {
        AgentID agentID = this.executor.getAgentID(this.tmsConfigurationContext.getHostName());
        AgentExecutor agentExecutor = this.executor.forAgent(agentID);
        logger.debug("Browse TMS: {} on: {}", (Object)this.instanceId, (Object)agentID);
        String path = (String)agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().getTmsInstallationPath(this.instanceId));
        return new RemoteFolder(agentExecutor, path, root);
    }

    public TerracottaManagementServerState getTmsState() {
        AgentID agentID = this.executor.getAgentID(this.tmsConfigurationContext.getHostName());
        logger.debug("Get state of TMS: {} on: {}", (Object)this.instanceId, (Object)agentID);
        return (TerracottaManagementServerState)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().getTmsState(this.instanceId));
    }

    public Tms start() {
        return this.start(Collections.emptyMap());
    }

    public Tms start(Map<String, String> envOverrides) {
        AgentID agentID = this.executor.getAgentID(this.tmsConfigurationContext.getHostName());
        logger.info("Starting TMS: {} on: {}", (Object)this.instanceId, (Object)agentID);
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().startTms(this.instanceId, envOverrides));
        return this;
    }

    public void stop() {
        this.stopTms();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }

    private void uninstall() {
        String tmsHostname = this.tmsConfigurationContext.getHostName();
        TerracottaManagementServerState terracottaServerState = this.getTmsState();
        if (terracottaServerState == null) {
            return;
        }
        if (terracottaServerState != TerracottaManagementServerState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: server " + tmsHostname + " already in state " + terracottaServerState);
        }
        AgentID agentID = this.executor.getAgentID(this.tmsConfigurationContext.getHostName());
        logger.info("Uninstalling TMS: {} from: {}", (Object)this.instanceId, (Object)agentID);
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        Distribution distribution = this.tmsConfigurationContext.getDistribution();
        TmsServerSecurityConfig securityConfig = this.tmsConfigurationContext.getSecurityConfig();
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().uninstallTms(this.instanceId, distribution, securityConfig, kitInstallationName, tmsHostname, kitInstallationPath));
    }

    private void install() {
        String tmsHostname = this.tmsConfigurationContext.getHostName();
        License license = this.tmsConfigurationContext.getLicense();
        Distribution distribution = this.tmsConfigurationContext.getDistribution();
        TmsServerSecurityConfig tmsServerSecurityConfig = this.tmsConfigurationContext.getSecurityConfig();
        TerracottaCommandLineEnvironment tcEnv = this.tmsConfigurationContext.getTerracottaCommandLineEnvironment();
        AgentID agentID = this.executor.getAgentID(tmsHostname);
        logger.info("Installing TMS: {} on: {}", (Object)this.instanceId, (Object)agentID);
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> AgentController.getInstance().installTms(this.instanceId, tmsHostname, distribution, license, tmsServerSecurityConfig, kitInstallationName, tcEnv, tmsHostname, kitInstallationPath);
        boolean isRemoteInstallationSuccessful = (Boolean)this.executor.execute(agentID, (IgniteCallable)callable);
        if (!isRemoteInstallationSuccessful) {
            try {
                this.executor.uploadKit(agentID, this.instanceId, distribution, kitInstallationName, this.localKitManager.getKitInstallationPath());
                this.executor.execute(agentID, (IgniteCallable)callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + tmsHostname, e);
            }
        }
    }

    private void stopTms() {
        TerracottaManagementServerState terracottaManagementServerState = this.getTmsState();
        if (terracottaManagementServerState == TerracottaManagementServerState.STOPPED) {
            return;
        }
        if (terracottaManagementServerState != TerracottaManagementServerState.STARTED) {
            throw new IllegalStateException("Cannot stop: TMS server , already in state " + terracottaManagementServerState);
        }
        AgentID agentID = this.executor.getAgentID(this.tmsConfigurationContext.getHostName());
        logger.info("Stopping TMS: {} on: {}", (Object)this.instanceId, (Object)agentID);
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().stopTms(this.instanceId));
        this.ensureStopped(this::getTmsState);
    }

    private void ensureStopped(Supplier<TerracottaManagementServerState> s) {
        try {
            while (s.get() != TerracottaManagementServerState.STOPPED) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

