/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.topology.InstanceId;

public class Voter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Voter.class);
    private final transient Executor executor;
    private final InstanceId instanceId;
    private final transient VoterConfigurationContext voterConfigurationContext;
    private final transient LocalKitManager localKitManager;
    private boolean closed = false;

    Voter(Executor executor, InstanceId instanceId, VoterConfigurationContext voterConfigurationContext) {
        this.voterConfigurationContext = voterConfigurationContext;
        this.instanceId = instanceId;
        this.executor = executor;
        this.localKitManager = new LocalKitManager(voterConfigurationContext.getDistribution());
        this.installAll();
    }

    private void installAll() {
        List<TerracottaVoter> terracottaVoters = this.voterConfigurationContext.getTerracottaVoters();
        for (TerracottaVoter terracottaVoter : terracottaVoters) {
            this.install(terracottaVoter);
        }
    }

    public TerracottaVoterState getTerracottaVoterState(TerracottaVoter terracottaVoter) {
        AgentID agentID = this.executor.getAgentID(terracottaVoter.getHostName());
        return (TerracottaVoterState)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().getVoterState(this.instanceId, terracottaVoter));
    }

    public Voter startAll() {
        this.voterConfigurationContext.getTerracottaVoters().stream().map(voter -> CompletableFuture.runAsync(() -> this.start((TerracottaVoter)voter))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public Voter start(TerracottaVoter terracottaVoter) {
        return this.start(terracottaVoter, Collections.emptyMap());
    }

    public Voter start(TerracottaVoter terracottaVoter, Map<String, String> envOverrides) {
        AgentID agentID = this.executor.getAgentID(terracottaVoter.getHostName());
        logger.info("Starting voter: {} on: {}", (Object)this.instanceId, (Object)agentID);
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().startVoter(this.instanceId, terracottaVoter, envOverrides));
        return this;
    }

    public Voter stopAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TerracottaVoter terracottaVoter : this.voterConfigurationContext.getTerracottaVoters()) {
            try {
                this.stop(terracottaVoter);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping all voters");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public Voter stop(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState == TerracottaVoterState.STOPPED) {
            return this;
        }
        AgentID agentID = this.executor.getAgentID(terracottaVoter.getHostName());
        logger.info("Stopping Voter: {} on: {}", (Object)this.instanceId, (Object)agentID);
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().stopVoter(this.instanceId, terracottaVoter));
        return this;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopAll();
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstallAll();
        }
    }

    private void install(TerracottaVoter terracottaVoter) {
        this.installWithKitManager(terracottaVoter);
    }

    private void installWithKitManager(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState != TerracottaVoterState.NOT_INSTALLED) {
            throw new IllegalStateException("Cannot install: voter " + terracottaVoter.getId() + " in state " + terracottaVoterState);
        }
        Distribution distribution = this.voterConfigurationContext.getDistribution();
        License license = this.voterConfigurationContext.getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.voterConfigurationContext.commandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.voterConfigurationContext.getSecurityRootDirectory();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        AgentID agentID = this.executor.getAgentID(terracottaVoter.getHostName());
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> AgentController.getInstance().installVoter(this.instanceId, terracottaVoter, distribution, license, kitInstallationName, securityRootDirectory, tcEnv, kitInstallationPath);
        logger.info("Installing Voter: {} on: {}", (Object)this.instanceId, (Object)agentID);
        boolean isRemoteInstallationSuccessful = (Boolean)this.executor.execute(agentID, (IgniteCallable)callable);
        if (!(isRemoteInstallationSuccessful || kitInstallationPath != null && AngelaProperties.KIT_COPY.getBooleanValue())) {
            try {
                this.executor.uploadKit(agentID, this.instanceId, distribution, kitInstallationName, this.localKitManager.getKitInstallationPath());
                this.executor.execute(agentID, (IgniteCallable)callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + terracottaVoter.getHostName(), e);
            }
        }
    }

    private void uninstallAll() {
        for (TerracottaVoter terracottaVoter : this.voterConfigurationContext.getTerracottaVoters()) {
            this.uninstall(terracottaVoter);
        }
    }

    private void uninstall(TerracottaVoter terracottaVoter) {
        TerracottaVoterState terracottaVoterState = this.getTerracottaVoterState(terracottaVoter);
        if (terracottaVoterState == null) {
            return;
        }
        if (terracottaVoterState != TerracottaVoterState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: voter " + terracottaVoter.getId() + " in state " + terracottaVoterState);
        }
        AgentID agentID = this.executor.getAgentID(terracottaVoter.getHostName());
        Distribution distribution = this.voterConfigurationContext.getDistribution();
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        logger.info("Uninstalling Voter: {} from: {}", (Object)this.instanceId, (Object)agentID);
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> AgentController.getInstance().uninstallVoter(this.instanceId, distribution, terracottaVoter, kitInstallationName);
        this.executor.execute(agentID, (IgniteRunnable)uninstaller);
    }
}

