/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.filesystem.TransportableFile;

public class RemoteFile {
    protected final transient AgentExecutor agentExecutor;
    protected final String parentName;
    protected final String name;

    public RemoteFile(AgentExecutor agentExecutor, String parentName, String name) {
        this.agentExecutor = agentExecutor;
        this.parentName = parentName;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsoluteName() {
        if (this.parentName == null) {
            return this.name;
        }
        return this.parentName + "/" + this.name;
    }

    public boolean isFolder() {
        return this instanceof RemoteFolder;
    }

    public void downloadTo(File path) throws IOException {
        this.downloadTo(path.toPath());
    }

    public void downloadTo(Path path) throws IOException {
        Files.write(path, this.downloadContents(), new OpenOption[0]);
    }

    private byte[] downloadContents() {
        String filename = this.getAbsoluteName();
        return (byte[])this.agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().downloadFile(filename));
    }

    public TransportableFile toTransportableFile() {
        return new TransportableFile(this.getName(), this.downloadContents());
    }

    public String toString() {
        return "[" + this.agentExecutor.getTarget() + "]:" + this.name;
    }
}

