/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.IgniteException;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.client.filesystem.RemoteFile;

public class RemoteFolder
extends RemoteFile {
    public RemoteFolder(AgentExecutor agentExecutor, String parentName, String name) {
        super(agentExecutor, parentName, name);
    }

    public List<RemoteFile> list() {
        String absoluteName = this.getAbsoluteName();
        List remoteFiles = (List)this.agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().listFiles(absoluteName));
        List remoteFolders = (List)this.agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().listFolders(absoluteName));
        ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
        result.addAll(remoteFiles.stream().map(s -> new RemoteFile(this.agentExecutor, this.getAbsoluteName(), (String)s)).collect(Collectors.toList()));
        result.addAll(remoteFolders.stream().map(s -> new RemoteFolder(this.agentExecutor, this.getAbsoluteName(), (String)s)).collect(Collectors.toList()));
        return result;
    }

    public void upload(File localFile) throws IOException {
        this.upload(localFile.toPath());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void upload(Path localFile) throws IOException {
        if (Files.isDirectory(localFile, new LinkOption[0])) {
            this.uploadFolder(".", localFile);
        } else {
            try (InputStream fis = Files.newInputStream(localFile, new OpenOption[0]);){
                this.upload(localFile.getFileName().toString(), fis);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void uploadFolder(String parentName, Path folder) throws IOException {
        try (Stream<Path> stream = Files.list(folder);){
            stream.forEach(f -> {
                block15: {
                    try {
                        String currentName = parentName + "/" + f.getFileName();
                        if (Files.isDirectory(f, new LinkOption[0])) {
                            this.uploadFolder(currentName, (Path)f);
                            break block15;
                        }
                        try (InputStream fis = Files.newInputStream(f, new OpenOption[0]);){
                            this.upload(currentName, fis);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
    }

    public void upload(String remoteFilename, URL localResourceUrl) throws IOException {
        try (InputStream in = localResourceUrl.openStream();){
            this.upload(remoteFilename, in);
        }
    }

    public void upload(String remoteFilename, InputStream localStream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)localStream);
        String filename = this.getAbsoluteName() + "/" + remoteFilename;
        this.agentExecutor.execute((IgniteRunnable & Serializable)() -> AgentController.getInstance().uploadFile(filename, data));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void downloadTo(Path localPath) throws IOException {
        byte[] bytes;
        String foldername = this.getAbsoluteName();
        try {
            bytes = (byte[])this.agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().downloadFolder(foldername));
        }
        catch (IgniteException ie) {
            throw new IOException("Error downloading remote folder '" + foldername + "' into local folder '" + localPath + "'", ie);
        }
        Files.createDirectories(localPath, new FileAttribute[0]);
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));){
            while (true) {
                OutputStream fos;
                block25: {
                    ZipEntry nextEntry;
                    if ((nextEntry = zis.getNextEntry()) == null) {
                        return;
                    }
                    String name = nextEntry.getName();
                    Path file = localPath.resolve(name);
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    fos = Files.newOutputStream(file, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)fos);
                        if (fos == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "/";
    }
}

