/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.support.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.client.AngelaOrchestrator;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.ClusterMonitor;
import org.terracotta.angela.client.ClusterTool;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Tms;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.Voter;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.support.junit.ExtendedTestRule;
import org.terracotta.angela.client.support.junit.ExtraLogging;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.utilities.test.matchers.Eventually;

public class AngelaRule
extends ExtendedTestRule
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AngelaRule.class);
    private final Supplier<AngelaOrchestrator> angelaOrchestratorSupplier;
    private ConfigurationContext configuration;
    private final boolean autoStart;
    private final boolean autoActivate;
    private ClusterFactory clusterFactory;
    private Supplier<Tsa> tsa;
    private Supplier<Cluster> cluster;
    private Supplier<Tms> tms;
    private Supplier<ClientArray> clientArray;
    private Supplier<ClusterMonitor> clusterMonitor;
    private Supplier<Voter> voter;
    private Supplier<ConfigTool> configTool;
    private Supplier<ClusterTool> clusterTool;

    public AngelaRule(AngelaOrchestrator angelaOrchestrator, ConfigurationContext configuration) {
        this(angelaOrchestrator, configuration, false, false);
    }

    public AngelaRule(AngelaOrchestrator angelaOrchestrator, ConfigurationContext configuration, boolean autoStart, boolean autoActivate) {
        this(() -> angelaOrchestrator, configuration, autoStart, autoActivate);
    }

    public AngelaRule(Supplier<AngelaOrchestrator> angelaOrchestratorSupplier, ConfigurationContext configuration, boolean autoStart, boolean autoActivate) {
        this.angelaOrchestratorSupplier = angelaOrchestratorSupplier;
        this.configuration = configuration;
        this.autoStart = autoStart;
        this.autoActivate = autoActivate;
    }

    public ConfigurationContext configure(ConfigurationContext configuration) {
        ConfigurationContext old = this.configuration;
        this.configuration = configuration;
        return old;
    }

    public void init(Description description) {
        this.before(description);
    }

    @Override
    protected void before(Description description) {
        String id = this.createTestId(description);
        AngelaOrchestrator angelaOrchestrator = this.angelaOrchestratorSupplier.get();
        this.clusterFactory = angelaOrchestrator.newClusterFactory(id, this.configuration);
        this.tsa = AngelaRule.memoize(this.clusterFactory::tsa);
        this.cluster = AngelaRule.memoize(this.clusterFactory::cluster);
        this.tms = AngelaRule.memoize(this.clusterFactory::tms);
        this.clientArray = AngelaRule.memoize(this.clusterFactory::firstClientArray);
        this.clusterMonitor = AngelaRule.memoize(this.clusterFactory::monitor);
        this.voter = AngelaRule.memoize(this.clusterFactory::voter);
        this.configTool = AngelaRule.memoize(this.clusterFactory::configTool);
        this.clusterTool = AngelaRule.memoize(this.clusterFactory::clusterTool);
        this.prepareLogging(description);
        if (this.autoStart) {
            this.startNodes();
            if (this.autoActivate) {
                this.configTool().attachAll();
                this.configTool().activate();
            }
        }
    }

    protected void prepareLogging(Description description) {
        Optional.ofNullable(this.getClass().getResource("/tc-logback.xml")).ifPresent(url -> this.tsa.get().getTsaConfigurationContext().getTopology().getServers().forEach(s -> {
            RemoteFolder folder = this.tsa.get().browse((TerracottaServer)s, "");
            try {
                folder.upload("logback-test.xml", (URL)url);
            }
            catch (IOException exp) {
                logger.warn("unable to upload logback-test.xml configuration: " + url + " on server: " + s.getServerSymbolicName(), (Throwable)exp);
            }
        }));
        Stream.of(Optional.ofNullable(description.getAnnotation(ExtraLogging.class)).map(ExtraLogging::value).map(s -> this.getClass().getResource((String)s)).orElse(null), this.getClass().getResource("/logback-ext-test.xml")).filter(Objects::nonNull).findFirst().ifPresent(url -> this.tsa.get().getTsaConfigurationContext().getTopology().getServers().forEach(s -> {
            RemoteFolder folder = this.tsa.get().browse((TerracottaServer)s, "");
            try {
                folder.upload("logback-ext-test.xml", (URL)url);
            }
            catch (IOException exp) {
                logger.warn("unable to upload logback-ext-test.xml configuration: " + url + " on server: " + s.getServerSymbolicName(), (Throwable)exp);
            }
        }));
        this.tsa.get().getTsaConfigurationContext().getTopology().getServers().forEach(s -> {
            try {
                RemoteFolder folder = this.tsa.get().browse((TerracottaServer)s, "");
                Properties props = new Properties();
                props.setProperty("serverWorkingDir", folder.getAbsoluteName());
                props.setProperty("serverId", s.getServerSymbolicName().getSymbolicName());
                props.setProperty("test.displayName", description.getDisplayName());
                props.setProperty("test.className", description.getClassName());
                props.setProperty("test.methodName", description.getMethodName());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                props.store(bos, "logging properties");
                bos.close();
                folder.upload("logbackVars.properties", new ByteArrayInputStream(bos.toByteArray()));
            }
            catch (IOException exp) {
                logger.warn("unable to upload logbackVars.properties on server: " + s.getServerSymbolicName(), (Throwable)exp);
            }
        });
    }

    protected String createTestId(Description description) {
        String id = description.getTestClass().getSimpleName();
        if (description.getMethodName() != null) {
            id = id + "_" + description.getMethodName();
        }
        return id;
    }

    @Override
    protected void after(Description description) {
        this.close();
    }

    @Override
    public void close() {
        if (this.clusterFactory != null) {
            this.clusterFactory.close();
            this.clusterFactory = null;
        }
    }

    public void startNodes() {
        List stripes = this.configuration.tsa().getTopology().getStripes();
        for (int stripeId = 1; stripeId <= stripes.size(); ++stripeId) {
            List stripe = (List)stripes.get(stripeId - 1);
            for (int nodeId = 1; nodeId <= stripe.size(); ++nodeId) {
                this.startNode(stripeId, nodeId);
            }
        }
    }

    public void startNode(int stripeId, int nodeId) {
        this.startNode(this.getNode(stripeId, nodeId), new String[0]);
    }

    public void startNode(int stripeId, int nodeId, String ... cli) {
        this.startNode(this.getNode(stripeId, nodeId), cli);
    }

    public void startNode(TerracottaServer node, String ... cli) {
        this.tsa().spawn(node, cli);
    }

    public void stopNode(int stripeId, int nodeId) {
        this.tsa().stop(this.getNode(stripeId, nodeId));
        this.waitForStopped(stripeId, nodeId);
    }

    public final void startNode(TerracottaServer node, Map<String, String> env, String ... cli) {
        this.tsa().spawn(node, env, cli);
    }

    public ClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public ConfigurationContext getConfiguration() {
        return this.configuration;
    }

    public int getStripeCount() {
        return this.configuration.tsa().getTopology().getStripes().size();
    }

    public int getNodeCount(int stripeId) {
        return this.getStripe(stripeId).size();
    }

    public List<TerracottaServer> getStripe(int stripeId) {
        if (stripeId < 1) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId);
        }
        List stripes = this.configuration.tsa().getTopology().getStripes();
        if (stripeId > stripes.size()) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId + ". There are " + stripes.size() + " stripe(s).");
        }
        return (List)stripes.get(stripeId - 1);
    }

    public TerracottaServer getNode(int stripeId, int nodeId) {
        if (nodeId < 1) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId);
        }
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        if (nodeId > nodes.size()) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId + ". Stripe ID: " + stripeId + " has " + nodes.size() + " nodes.");
        }
        return nodes.get(nodeId - 1);
    }

    public int getNodePort(int stripeId, int nodeId) {
        return this.getNode(stripeId, nodeId).getTsaPort();
    }

    public int getNodeGroupPort(int stripeId, int nodeId) {
        return this.getNode(stripeId, nodeId).getTsaGroupPort();
    }

    public final InetSocketAddress getNodeAddress(int stripeId, int nodeId) {
        return InetSocketAddress.createUnresolved(this.getNode(stripeId, nodeId).getHostName(), this.getNodePort(stripeId, nodeId));
    }

    public OptionalInt findActive(int stripeId) {
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        return IntStream.rangeClosed(1, nodes.size()).filter(nodeId -> this.tsa().getState((TerracottaServer)nodes.get(nodeId - 1)) == TerracottaServerState.STARTED_AS_ACTIVE).findFirst();
    }

    public int[] findPassives(int stripeId) {
        List<TerracottaServer> nodes = this.getStripe(stripeId);
        return IntStream.rangeClosed(1, nodes.size()).filter(nodeId -> this.tsa().getState((TerracottaServer)nodes.get(nodeId - 1)) == TerracottaServerState.STARTED_AS_PASSIVE).toArray();
    }

    public final Path getServerHome() {
        return this.getServerHome(this.getNode(1, 1));
    }

    public final Path getServerHome(TerracottaServer server) {
        return Paths.get(this.tsa().browse(server, "").getAbsoluteName(), new String[0]);
    }

    public final void waitUntil(ToolExecutionResult result, Matcher<ToolExecutionResult> matcher) {
        this.waitUntil(() -> result, matcher);
    }

    public final void waitUntilServerStdOut(TerracottaServer server, String matcher) {
        Assert.assertThat(() -> this.serverStdOut(server), (Matcher)Eventually.within((Duration)Duration.ofDays(1L)).matches(Matchers.hasItem((Matcher)Matchers.containsString((String)matcher))));
    }

    public final void assertThatServerStdOut(TerracottaServer server, String matcher) {
        Assert.assertThat(this.serverStdOut(server), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)matcher)));
    }

    public final void assertThatServerStdOut(TerracottaServer server, Matcher<String> matcher) {
        Assert.assertThat(this.serverStdOut(server), (Matcher)Matchers.hasItem(matcher));
    }

    public List<String> serverStdOut(int stripeId, int nodeId) {
        return this.serverStdOut(this.getNode(stripeId, nodeId));
    }

    public List<String> serverStdOut(TerracottaServer server) {
        try {
            return Files.readAllLines(this.getServerHome(server).resolve("stdout.txt"));
        }
        catch (IOException io) {
            return Collections.emptyList();
        }
    }

    public final void waitUntilServerLogs(TerracottaServer server, String matcher) {
        Assert.assertThat(() -> this.serverLogs(server), (Matcher)Eventually.within((Duration)Duration.ofDays(1L)).matches(Matchers.hasItem((Matcher)Matchers.containsString((String)matcher))));
    }

    public final void assertThatServerLogs(TerracottaServer server, String matcher) {
        Assert.assertThat(this.serverLogs(server), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)matcher)));
    }

    public final void assertThatServerLogs(TerracottaServer server, Matcher<String> matcher) {
        Assert.assertThat(this.serverLogs(server), (Matcher)Matchers.hasItem(matcher));
    }

    public List<String> serverLogs(int stripeId, int nodeId) {
        return this.serverLogs(this.getNode(stripeId, nodeId));
    }

    public List<String> serverLogs(TerracottaServer server) {
        try {
            return Files.readAllLines(this.getServerHome(server).resolve(server.getLogs()).resolve(server.getServerSymbolicName().getSymbolicName()).resolve("terracotta.server.log"));
        }
        catch (IOException io) {
            return Collections.emptyList();
        }
    }

    public final <T> void waitUntil(Supplier<T> callable, Matcher<T> matcher) {
        Assert.assertThat(callable, (Matcher)Eventually.within((Duration)Duration.ofDays(1L)).matches(matcher));
    }

    public final int waitForActive(int stripeId) {
        this.waitUntil(() -> this.findActive(stripeId).isPresent(), Matchers.is((Object)true));
        return this.findActive(stripeId).getAsInt();
    }

    public final void waitForActive(int stripeId, int nodeId) {
        this.waitUntil(() -> this.tsa().getState(this.getNode(stripeId, nodeId)), Matchers.is((Matcher)Matchers.equalTo((Object)TerracottaServerState.STARTED_AS_ACTIVE)));
    }

    public final void waitForPassive(int stripeId, int nodeId) {
        this.waitUntil(() -> this.tsa().getState(this.getNode(stripeId, nodeId)), Matchers.is((Matcher)Matchers.equalTo((Object)TerracottaServerState.STARTED_AS_PASSIVE)));
    }

    public final void waitForDiagnostic(int stripeId, int nodeId) {
        this.waitUntil(() -> this.tsa().getState(this.getNode(stripeId, nodeId)), Matchers.is((Matcher)Matchers.equalTo((Object)TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE)));
    }

    public final void waitForStopped(int stripeId, int nodeId) {
        this.waitUntil(() -> this.tsa().getState(this.getNode(stripeId, nodeId)), Matchers.is((Matcher)Matchers.equalTo((Object)TerracottaServerState.STOPPED)));
    }

    public final int[] waitForPassives(int stripeId) {
        int expectedPassiveCount = this.getNodeCount(stripeId) - 1;
        this.waitUntil(() -> this.findPassives(stripeId).length, Matchers.is((Matcher)Matchers.equalTo((Object)expectedPassiveCount)));
        return this.findPassives(stripeId);
    }

    public final int[] waitForNPassives(int stripeId, int count) {
        this.waitUntil(() -> this.findPassives(stripeId).length, Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(count))));
        return this.findPassives(stripeId);
    }

    public Tsa tsa() {
        return this.tsa.get();
    }

    public ConfigTool configTool() {
        return this.configTool.get();
    }

    public ClusterTool clusterTool() {
        return this.clusterTool.get();
    }

    public Cluster cluster() {
        return this.cluster.get();
    }

    public Tms tms() {
        return this.tms.get();
    }

    public ClientArray clientArray() {
        return this.clientArray.get();
    }

    public ClusterMonitor monitor() {
        return this.clusterMonitor.get();
    }

    public Voter voter() {
        return this.voter.get();
    }

    private static <T> Supplier<T> memoize(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T t;

            @Override
            public T get() {
                if (this.t == null) {
                    this.t = supplier.get();
                }
                return this.t;
            }
        };
    }
}

