/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.filesystem.TransportableFile;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.UniversalPath;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class ClusterMonitor
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ClusterMonitor.class);
    private final InstanceId instanceId;
    private final transient Map<String, AgentExecutor> executors;
    private final Map<HardwareMetric, MonitoringCommand> commands;
    private boolean closed = false;

    ClusterMonitor(Executor executor, InstanceId instanceId, Set<String> hostnames, Map<HardwareMetric, MonitoringCommand> commands) {
        this.instanceId = instanceId;
        this.executors = hostnames.stream().collect(Collectors.toMap(Function.identity(), hostname -> executor.forAgent(executor.getAgentID(hostname))));
        this.commands = commands;
    }

    public ClusterMonitor startOnAll() {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        for (Map.Entry<String, AgentExecutor> entry : this.executors.entrySet()) {
            logger.info("Starting monitoring: {} on: {} with agent: {}", new Object[]{this.commands.keySet(), entry.getKey(), entry.getValue().getTarget()});
            try {
                entry.getValue().execute((IgniteRunnable & Serializable)() -> AgentController.getInstance().startHardwareMonitoring(this.getWorkingPath(), this.commands));
            }
            catch (RuntimeException e) {
                exceptions.add(new RuntimeException("Error starting hardware monitoring on: " + entry.getValue().getTarget() + ". Err: " + e.getMessage(), e));
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error starting cluster monitors");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public ClusterMonitor stopOnAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<String, AgentExecutor> entry : this.executors.entrySet()) {
            try {
                entry.getValue().execute((IgniteRunnable & Serializable)() -> AgentController.getInstance().stopHardwareMonitoring());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping cluster monitors");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public void downloadTo(File localPath) {
        this.downloadTo(localPath.toPath());
    }

    public void downloadTo(Path localPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Map.Entry<String, AgentExecutor> entry : this.executors.entrySet()) {
            try {
                UniversalPath fromRemote = (UniversalPath)entry.getValue().execute((IgniteCallable & Serializable)() -> UniversalPath.fromLocalPath((Path)this.getWorkingPath().resolve("metrics")));
                Path toLocal = localPath.resolve(entry.getKey());
                logger.info("Downloading remote metrics from: {} to: {}", (Object)fromRemote, (Object)toLocal);
                new RemoteFolder(entry.getValue(), null, fromRemote.toString()).downloadTo(toLocal);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void processMetrics(BiConsumer<String, TransportableFile> processor) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<String, AgentExecutor> entry : this.executors.entrySet()) {
            try {
                UniversalPath metricsPath = (UniversalPath)entry.getValue().execute((IgniteCallable & Serializable)() -> UniversalPath.fromLocalPath((Path)this.getWorkingPath().resolve("metrics")));
                RemoteFolder remoteFolder = new RemoteFolder(entry.getValue(), null, metricsPath.toString());
                remoteFolder.list().forEach(remoteFile -> processor.accept((String)entry.getKey(), remoteFile.toTransportableFile()));
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading cluster monitor remote files");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    private Path getWorkingPath() {
        return Agent.WORK_DIR.resolve(this.instanceId.toString());
    }

    public boolean isMonitoringRunning(HardwareMetric metric) {
        for (Map.Entry<String, AgentExecutor> entry : this.executors.entrySet()) {
            boolean running = (Boolean)entry.getValue().execute((IgniteCallable & Serializable)() -> AgentController.getInstance().isMonitoringRunning(metric));
            if (running) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopOnAll();
    }
}

