/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.client.Client;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;

public class Jcmd {
    private final TerracottaCommandLineEnvironment tcEnv;
    private final Executor executor;
    private final InstanceId instanceId;
    private final TerracottaServer terracottaServer;
    private final Client client;

    Jcmd(Executor executor, InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv) {
        this.executor = executor;
        this.instanceId = instanceId;
        this.terracottaServer = terracottaServer;
        this.client = null;
        this.tcEnv = tcEnv;
    }

    Jcmd(Executor executor, Client client, TerracottaCommandLineEnvironment tcEnv) {
        this.executor = executor;
        this.instanceId = null;
        this.terracottaServer = null;
        this.client = client;
        this.tcEnv = tcEnv;
    }

    public ToolExecutionResult executeCommand(String ... arguments) {
        if (this.terracottaServer != null) {
            AgentID agentID = this.executor.getAgentID(this.terracottaServer.getHostName());
            return (ToolExecutionResult)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().serverJcmd(this.instanceId, this.terracottaServer, this.tcEnv, arguments));
        }
        if (this.client != null) {
            AgentID agentID = this.executor.getAgentID(this.client.getHostName());
            int pid = this.client.getPid();
            return (ToolExecutionResult)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().clientJcmd(pid, this.tcEnv, arguments));
        }
        throw new AssertionError();
    }
}

