/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Cmd;
import org.terracotta.angela.client.Jcmd;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.net.DisruptionController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class Tsa
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Tsa.class);
    private final transient Executor executor;
    private final InstanceId instanceId;
    private final transient DisruptionController disruptionController;
    private final transient TsaConfigurationContext tsaConfigurationContext;
    private final transient LocalKitManager localKitManager;
    private final transient PortAllocator portAllocator;
    private boolean closed = false;

    Tsa(Executor executor, PortAllocator portAllocator, InstanceId instanceId, TsaConfigurationContext tsaConfigurationContext) {
        this.portAllocator = portAllocator;
        this.tsaConfigurationContext = tsaConfigurationContext;
        this.instanceId = instanceId;
        this.executor = executor;
        this.disruptionController = new DisruptionController(executor, instanceId, tsaConfigurationContext.getTopology());
        this.localKitManager = new LocalKitManager(portAllocator, tsaConfigurationContext.getTopology().getDistribution());
        this.installAll();
    }

    public TsaConfigurationContext getTsaConfigurationContext() {
        return this.tsaConfigurationContext;
    }

    public DisruptionController getDisruptionController() {
        return this.disruptionController;
    }

    public PortAllocator getPortAllocator() {
        return this.portAllocator;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String licensePath(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            throw new IllegalStateException("Cannot get license path: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.debug("Reading license path of TSA: {} from: {}", (Object)this.instanceId, (Object)agentID);
        return (String)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().getTsaLicensePath(this.instanceId, terracottaServer));
    }

    void installAll() {
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        for (TerracottaServer terracottaServer : configurationManager.getServers()) {
            this.install(terracottaServer, topology);
        }
    }

    void install(TerracottaServer terracottaServer, Topology topology) {
        this.installWithKitManager(terracottaServer, topology, this.localKitManager);
    }

    private void installWithKitManager(TerracottaServer terracottaServer, Topology topology, LocalKitManager localKitManager) {
        topology.init(this.portAllocator);
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState != TerracottaServerState.NOT_INSTALLED) {
            throw new IllegalStateException("Cannot install: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
        }
        Distribution distribution = localKitManager.getDistribution();
        License license = this.tsaConfigurationContext.getLicense();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue(), this.tsaConfigurationContext.getTerracottaCommandLineEnvironment("install"));
        String kitInstallationName = localKitManager.getKitInstallationName();
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.info("Installing TSA: {} on: {}", (Object)this.instanceId, (Object)agentID);
        if (kitInstallationPath == null || AngelaProperties.KIT_COPY.getBooleanValue()) {
            IgniteCallable & Serializable installClosure = (IgniteCallable & Serializable)() -> AgentController.getInstance().installTsa(this.instanceId, terracottaServer, license, kitInstallationName, distribution, topology, null);
            boolean isRemoteInstallationSuccessful = (Boolean)this.executor.execute(agentID, (IgniteCallable)installClosure);
            if (!isRemoteInstallationSuccessful) {
                try {
                    logger.debug("Uploading: {} on: {}", (Object)distribution, (Object)agentID);
                    this.executor.uploadKit(agentID, this.instanceId, distribution, kitInstallationName, localKitManager.getKitInstallationPath());
                    this.executor.execute(agentID, (IgniteCallable)installClosure);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot upload kit to " + terracottaServer.getHostName(), e);
                }
            }
        } else {
            this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().installTsa(this.instanceId, terracottaServer, license, kitInstallationName, distribution, topology, kitInstallationPath));
        }
    }

    public Tsa upgrade(TerracottaServer server, Distribution newDistribution) {
        logger.info("Upgrading TSA: {} to: {}", (Object)server, (Object)newDistribution);
        this.uninstall(server);
        LocalKitManager localKitManager = new LocalKitManager(this.portAllocator, newDistribution);
        this.installWithKitManager(server, this.tsaConfigurationContext.getTopology(), localKitManager);
        return this;
    }

    private void uninstallAll() {
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer terracottaServer : topology.getServers()) {
            this.uninstall(terracottaServer);
        }
    }

    private void uninstall(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == null) {
            return;
        }
        if (terracottaServerState != TerracottaServerState.STOPPED) {
            throw new IllegalStateException("Cannot uninstall: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
        }
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        Topology topology = this.tsaConfigurationContext.getTopology();
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        logger.info("Uninstalling TSA: {} from: {}", (Object)this.instanceId, (Object)agentID);
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> AgentController.getInstance().uninstallTsa(this.instanceId, topology, terracottaServer, kitInstallationName, kitInstallationPath);
        this.executor.execute(agentID, (IgniteRunnable)uninstaller);
    }

    public Tsa createAll(String ... startUpArgs) {
        this.tsaConfigurationContext.getTopology().getServers().stream().map(server -> CompletableFuture.runAsync(() -> this.create((TerracottaServer)server, startUpArgs))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public Cmd cmd(TerracottaServer terracottaServer) {
        return new Cmd(this.executor, this.instanceId, terracottaServer);
    }

    public Jcmd jcmd(TerracottaServer terracottaServer) {
        String whatFor = "Jcmd" + terracottaServer.getServerSymbolicName().getSymbolicName();
        TerracottaCommandLineEnvironment tcEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment(whatFor);
        return new Jcmd(this.executor, this.instanceId, terracottaServer, tcEnv);
    }

    public Tsa create(TerracottaServer terracottaServer, String ... startUpArgs) {
        return this.create(terracottaServer, Collections.emptyMap(), startUpArgs);
    }

    public Tsa create(TerracottaServer terracottaServer, Map<String, String> envOverrides, String ... startUpArgs) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        switch (terracottaServerState) {
            case STARTING: 
            case STARTED_AS_ACTIVE: 
            case STARTED_AS_PASSIVE: 
            case STARTED_IN_DIAGNOSTIC_MODE: {
                return this;
            }
            case STOPPED: {
                AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
                logger.info("Creating TSA: {} on: {}", (Object)this.instanceId, (Object)agentID);
                String whatFor = "Server-" + terracottaServer.getServerSymbolicName().getSymbolicName();
                TerracottaCommandLineEnvironment cliEnv = this.tsaConfigurationContext.getTerracottaCommandLineEnvironment(whatFor);
                Duration inactivityKillerDelay = this.tsaConfigurationContext.getInactivityKillerDelay();
                IgniteRunnable & Serializable tsaCreator = (IgniteRunnable & Serializable)() -> AgentController.getInstance().createTsa(this.instanceId, terracottaServer, cliEnv, envOverrides, Arrays.asList(startUpArgs), inactivityKillerDelay);
                this.executor.execute(agentID, (IgniteRunnable)tsaCreator);
                return this;
            }
        }
        throw new IllegalStateException("Cannot create: server " + terracottaServer.getServerSymbolicName() + " in state " + terracottaServerState);
    }

    public Tsa startAll(String ... startUpArgs) {
        this.tsaConfigurationContext.getTopology().getServers().stream().map(server -> CompletableFuture.runAsync(() -> this.start((TerracottaServer)server, startUpArgs))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public DisruptionController disruptionController() {
        return this.disruptionController;
    }

    public Tsa start(TerracottaServer terracottaServer, String ... startUpArgs) {
        return this.start(terracottaServer, Collections.emptyMap(), startUpArgs);
    }

    public Tsa start(TerracottaServer terracottaServer, Map<String, String> envOverrides, String ... startUpArgs) {
        this.spawn(terracottaServer, envOverrides, startUpArgs);
        IgniteRunnable & Serializable runnable = (IgniteRunnable & Serializable)() -> AgentController.getInstance().waitForTsaInState(this.instanceId, terracottaServer, EnumSet.of(TerracottaServerState.STARTED_AS_ACTIVE, TerracottaServerState.STARTED_AS_PASSIVE, TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE, TerracottaServerState.START_SUSPENDED, TerracottaServerState.STOPPED));
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        this.executor.execute(agentID, (IgniteRunnable)runnable);
        logger.info("TSA: {} started on: {}", (Object)this.instanceId, (Object)agentID);
        return this;
    }

    public Tsa spawnAll(String ... startUpArgs) {
        this.tsaConfigurationContext.getTopology().getServers().stream().map(server -> CompletableFuture.runAsync(() -> this.spawn((TerracottaServer)server, startUpArgs))).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).ifPresent(CompletableFuture::join);
        return this;
    }

    public Tsa spawn(TerracottaServer terracottaServer, String ... startUpArgs) {
        return this.spawn(terracottaServer, Collections.emptyMap(), startUpArgs);
    }

    public Tsa spawn(TerracottaServer terracottaServer, Map<String, String> envOverrides, String ... startUpArgs) {
        this.create(terracottaServer, envOverrides, startUpArgs);
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.info("TSA: {} starting on: {}", (Object)this.instanceId, (Object)agentID);
        return this;
    }

    public Tsa stopAll() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer terracottaServer : topology.getServers()) {
            try {
                this.stop(terracottaServer);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error stopping all servers");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
        return this;
    }

    public Tsa stop(TerracottaServer terracottaServer) {
        TerracottaServerState terracottaServerState = this.getState(terracottaServer);
        if (terracottaServerState == TerracottaServerState.STOPPED) {
            return this;
        }
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.info("Stopping TSA: {} on: {}", (Object)this.instanceId, (Object)agentID);
        this.executor.execute(agentID, (IgniteRunnable & Serializable)() -> AgentController.getInstance().stopTsa(this.instanceId, terracottaServer));
        return this;
    }

    public Map<ServerSymbolicName, Integer> updateToProxiedPorts() {
        return this.disruptionController.updateTsaPortsWithProxy(this.tsaConfigurationContext.getTopology(), this.portAllocator);
    }

    public TerracottaServerState getState(TerracottaServer terracottaServer) {
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.debug("Getting state for TSA: {} on: {}", (Object)this.instanceId, (Object)agentID);
        return (TerracottaServerState)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().getTsaState(this.instanceId, terracottaServer));
    }

    public Map<ServerSymbolicName, Integer> getProxyGroupPortsForServer(TerracottaServer terracottaServer) {
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        logger.debug("Getting proxy group ports for TSA: {} on: {}", (Object)this.instanceId, (Object)agentID);
        return (Map)this.executor.execute(agentID, (IgniteCallable & Serializable)() -> AgentController.getInstance().getProxyGroupPortsForServer(this.instanceId, terracottaServer));
    }

    public Collection<TerracottaServer> getStarted() {
        ArrayList<TerracottaServer> allRunningServers = new ArrayList<TerracottaServer>();
        allRunningServers.addAll(this.getActives());
        allRunningServers.addAll(this.getPassives());
        allRunningServers.addAll(this.getDiagnosticModeSevers());
        return allRunningServers;
    }

    public Collection<TerracottaServer> getStopped() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STOPPED) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public Collection<TerracottaServer> getPassives() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_AS_PASSIVE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public Collection<TerracottaServer> waitForPassives(int count) throws InterruptedException {
        Collection<TerracottaServer> terracottaServers;
        while ((terracottaServers = this.getPassives()).size() < count) {
            Thread.sleep(200L);
        }
        return terracottaServers;
    }

    public TerracottaServer getPassive() {
        Collection<TerracottaServer> servers = this.getPassives();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one Passive Terracotta server, found " + servers.size());
    }

    public TerracottaServer waitForPassive() throws InterruptedException {
        TerracottaServer terracottaServer;
        while ((terracottaServer = this.getPassive()) == null) {
            Thread.sleep(200L);
        }
        return terracottaServer;
    }

    public Collection<TerracottaServer> getActives() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_AS_ACTIVE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public Collection<TerracottaServer> getServer(ServerSymbolicName symbolicName) {
        return this.tsaConfigurationContext.getTopology().getServers().stream().filter(server -> server.getServerSymbolicName().equals((Object)symbolicName)).collect(Collectors.toList());
    }

    public TerracottaServer getServer(int stripeIndex, int serverIndex) {
        return this.tsaConfigurationContext.getTopology().getServer(stripeIndex, serverIndex);
    }

    public Collection<Integer> getStripeIdOf(ServerSymbolicName symbolicName) {
        ArrayList<Integer> stripeIndices = new ArrayList<Integer>();
        List stripes = this.tsaConfigurationContext.getTopology().getStripes();
        for (int i = 0; i < stripes.size(); ++i) {
            List stripe = (List)stripes.get(i);
            if (!stripe.stream().anyMatch(server -> server.getServerSymbolicName().equals((Object)symbolicName))) continue;
            stripeIndices.add(i);
        }
        return stripeIndices;
    }

    public TerracottaServer waitForActive() throws InterruptedException {
        TerracottaServer terracottaServer;
        while ((terracottaServer = this.getActive()) == null) {
            Thread.sleep(200L);
        }
        return terracottaServer;
    }

    public TerracottaServer getActive() {
        Collection<TerracottaServer> servers = this.getActives();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one Active Terracotta server, found " + servers.size());
    }

    public Collection<TerracottaServer> getDiagnosticModeSevers() {
        ArrayList<TerracottaServer> result = new ArrayList<TerracottaServer>();
        for (TerracottaServer terracottaServer : this.tsaConfigurationContext.getTopology().getServers()) {
            if (this.getState(terracottaServer) != TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE) continue;
            result.add(terracottaServer);
        }
        return result;
    }

    public TerracottaServer getDiagnosticModeServer() {
        Collection<TerracottaServer> servers = this.getDiagnosticModeSevers();
        switch (servers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return servers.iterator().next();
            }
        }
        throw new IllegalStateException("There is more than one diagnostic mode server, found " + servers.size());
    }

    public URI uri() {
        if (this.disruptionController == null) {
            throw new IllegalStateException("uri cannot be built from a client lambda - please call uri() from the test code instead");
        }
        Topology topology = this.tsaConfigurationContext.getTopology();
        Map proxyTsaPorts = topology.isNetDisruptionEnabled() ? this.disruptionController.getProxyTsaPorts() : Collections.emptyMap();
        return topology.getDistribution().createDistributionController().tsaUri((Collection)topology.getServers(), proxyTsaPorts);
    }

    public RemoteFolder browse(TerracottaServer terracottaServer, String root) {
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        AgentExecutor agentExecutor = this.executor.forAgent(agentID);
        String path = (String)agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().getTsaInstallPath(this.instanceId, terracottaServer));
        return new RemoteFolder(agentExecutor, path, root);
    }

    public RemoteFolder browseFromKitLocation(TerracottaServer terracottaServer, String relativePath) {
        AgentID agentID = this.executor.getAgentID(terracottaServer.getHostName());
        AgentExecutor agentExecutor = this.executor.forAgent(agentID);
        String kitLocation = (String)agentExecutor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().getTsaKitLocation(this.instanceId, terracottaServer));
        return new RemoteFolder(agentExecutor, kitLocation, relativePath);
    }

    public void uploadPlugin(File localPluginFile) {
        this.uploadPlugin(localPluginFile.toPath());
    }

    public void uploadPlugin(Path localPluginFile) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        for (TerracottaServer server : topology.getServers()) {
            try {
                this.browseFromKitLocation(server, topology.getDistribution().createDistributionController().pluginJarsRootFolderName(topology.getDistribution())).upload(localPluginFile);
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error uploading TSA plugin");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void uploadDataDirectories(File localRootPath) {
        this.uploadDataDirectories(localRootPath.toPath());
    }

    public void uploadDataDirectories(Path localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        if (configurationManager instanceof TcConfigManager) {
            TcConfigManager tcConfigProvider = (TcConfigManager)configurationManager;
            List tcConfigs = tcConfigProvider.getTcConfigs();
            for (TcConfig tcConfig : tcConfigs) {
                Collection dataDirectories = tcConfig.getDataDirectories().values();
                List servers = tcConfig.getServers();
                for (String directory : dataDirectories) {
                    for (TerracottaServer server : servers) {
                        try {
                            Path localFile = localRootPath.resolve(server.getServerSymbolicName().getSymbolicName()).resolve(directory);
                            this.browse(server, directory).upload(localFile);
                        }
                        catch (IOException ioe) {
                            exceptions.add(ioe);
                        }
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error uploading TSA data directories");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    public void downloadDataDirectories(File localRootPath) {
        this.downloadDataDirectories(localRootPath.toPath());
    }

    public void downloadDataDirectories(Path localRootPath) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        Topology topology = this.tsaConfigurationContext.getTopology();
        ConfigurationManager configurationManager = topology.getConfigurationManager();
        if (configurationManager instanceof TcConfigManager) {
            TcConfigManager tcConfigProvider = (TcConfigManager)configurationManager;
            List tcConfigs = tcConfigProvider.getTcConfigs();
            for (TcConfig tcConfig : tcConfigs) {
                Map dataDirectories = tcConfig.getDataDirectories();
                List servers = tcConfig.getServers();
                for (TerracottaServer server : servers) {
                    for (Map.Entry entry : dataDirectories.entrySet()) {
                        String directory = (String)entry.getValue();
                        try {
                            this.browse(server, directory).downloadTo(localRootPath.resolve(server.getServerSymbolicName().getSymbolicName()).resolve(directory));
                        }
                        catch (IOException ioe) {
                            exceptions.add(ioe);
                        }
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            RuntimeException re = new RuntimeException("Error downloading TSA data directories");
            exceptions.forEach(re::addSuppressed);
            throw re;
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stopAll();
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstallAll();
        }
        if (this.tsaConfigurationContext.getTopology().isNetDisruptionEnabled()) {
            try {
                this.disruptionController.close();
            }
            catch (Exception e) {
                logger.error("Error when trying to close traffic controller : {}", (Object)e.getMessage());
            }
        }
    }
}

