/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Closeable;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.com.IgniteFreeExecutor;
import org.terracotta.angela.agent.com.IgniteLocalExecutor;
import org.terracotta.angela.agent.com.IgniteSshRemoteExecutor;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.ConfigurationContextVisitor;
import org.terracotta.angela.client.config.TsaConfigurationContext;
import org.terracotta.angela.client.config.VoterConfigurationContext;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;

public class AngelaOrchestrator
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AngelaOrchestrator.class);
    private final Agent mainAgent;
    private final AgentController agentController;
    private final Executor executor;
    private final PortAllocator portAllocator;

    private AngelaOrchestrator(Agent mainAgent, Executor executor, PortAllocator portAllocator) {
        this.mainAgent = mainAgent;
        this.executor = executor;
        this.portAllocator = portAllocator;
        this.agentController = new AgentController(mainAgent.getAgentID(), portAllocator);
        AgentController.setUniqueInstance((AgentController)this.agentController);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public PortAllocator getPortAllocator() {
        return this.portAllocator;
    }

    public ClusterFactory newClusterFactory(String idPrefix, final ConfigurationContext configurationContext) {
        configurationContext.visit(new ConfigurationContextVisitor(){

            @Override
            public void visit(TsaConfigurationContext tsaConfigurationContext) {
                Topology topology = tsaConfigurationContext.getTopology();
                if (topology != null) {
                    logger.trace("Allocating ports for servers...");
                    topology.init(AngelaOrchestrator.this.portAllocator);
                }
            }

            @Override
            public void visit(VoterConfigurationContext voterConfigurationContext) {
                for (TerracottaVoter terracottaVoter : voterConfigurationContext.getTerracottaVoters()) {
                    List hostPorts = terracottaVoter.getHostPorts();
                    List serverNames = terracottaVoter.getServerNames();
                    if (hostPorts.isEmpty() && serverNames.isEmpty()) {
                        throw new IllegalArgumentException("Voter incorrectly configured: missing hosts/ports or server names");
                    }
                    if (!hostPorts.isEmpty()) continue;
                    for (String serverName : serverNames) {
                        hostPorts.add(configurationContext.tsa().getTopology().getServers().stream().filter(server -> server.getServerSymbolicName().getSymbolicName().equals(serverName)).findFirst().map(TerracottaServer::getHostPort).orElseThrow(() -> new IllegalArgumentException("Incorrect voter configuration: server name '" + serverName + "' not found")));
                    }
                    logger.trace("Voter configured to connect to: " + hostPorts);
                }
            }
        });
        return new ClusterFactory(this.executor, this.portAllocator, idPrefix, configurationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.executor.close();
        }
        finally {
            try {
                this.mainAgent.close();
            }
            finally {
                try {
                    this.portAllocator.close();
                }
                finally {
                    AgentController.removeUniqueInstance((AgentController)this.agentController);
                }
            }
        }
    }

    public static AngelaOrchestratorBuilder builder() {
        return new AngelaOrchestratorBuilder();
    }

    public static class AngelaOrchestratorBuilder {
        private final UUID group = UUID.randomUUID();
        private PortAllocator portAllocator = new DefaultPortAllocator();
        private Supplier<Agent> agentBuilder;
        private Function<Agent, Executor> executorBuilder;
        private String mode;

        private AngelaOrchestratorBuilder() {
            this.igniteRemote();
        }

        @Deprecated
        public AngelaOrchestratorBuilder local() {
            return this.igniteFree();
        }

        public AngelaOrchestratorBuilder withPortAllocator(final PortAllocator portAllocator) {
            this.portAllocator = new PortAllocator(){

                public PortAllocator.PortReservation reserve(int portCounts) {
                    return portAllocator.reserve(portCounts);
                }

                public void close() {
                }
            };
            return this;
        }

        public AngelaOrchestratorBuilder igniteRemote() {
            this.agentBuilder = () -> Agent.igniteOrchestrator((UUID)this.group, (PortAllocator)this.portAllocator);
            this.executorBuilder = agent -> new IgniteSshRemoteExecutor(agent.getGroupId(), agent.getAgentID(), agent.getIgnite());
            this.mode = IgniteSshRemoteExecutor.class.getSimpleName();
            return this;
        }

        public AngelaOrchestratorBuilder igniteRemote(Consumer<IgniteSshRemoteExecutor> configurator) {
            this.agentBuilder = () -> Agent.igniteOrchestrator((UUID)this.group, (PortAllocator)this.portAllocator);
            this.executorBuilder = agent -> {
                IgniteSshRemoteExecutor executor = new IgniteSshRemoteExecutor(agent);
                configurator.accept(executor);
                return executor;
            };
            this.mode = IgniteSshRemoteExecutor.class.getSimpleName();
            return this;
        }

        public AngelaOrchestratorBuilder igniteLocal() {
            this.agentBuilder = () -> Agent.igniteOrchestrator((UUID)this.group, (PortAllocator)this.portAllocator);
            this.executorBuilder = IgniteLocalExecutor::new;
            this.mode = IgniteLocalExecutor.class.getSimpleName();
            return this;
        }

        public AngelaOrchestratorBuilder igniteFree() {
            this.agentBuilder = () -> Agent.local((UUID)this.group);
            this.executorBuilder = IgniteFreeExecutor::new;
            this.mode = IgniteFreeExecutor.class.getSimpleName();
            return this;
        }

        public AngelaOrchestrator build() {
            Agent agent = this.agentBuilder.get();
            Executor executor = this.executorBuilder.apply(agent);
            return new AngelaOrchestrator(agent, executor, this.portAllocator);
        }

        public String toString() {
            return this.mode;
        }
    }
}

