/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.kit.LocalKitManager;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ToolConfigurationContext;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class ClusterTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterTool.class);
    private final InstanceId instanceId;
    private final transient AgentExecutor executor;
    private final transient ToolConfigurationContext configContext;
    private final transient LocalKitManager localKitManager;
    private final transient Tsa tsa;

    ClusterTool(Executor executor, PortAllocator portAllocator, InstanceId instanceId, ToolConfigurationContext configContext, Tsa tsa) {
        this.instanceId = instanceId;
        this.executor = executor.forAgent(executor.getAgentID(configContext.getHostName()));
        this.configContext = configContext;
        this.localKitManager = new LocalKitManager(portAllocator, configContext.getDistribution());
        this.tsa = tsa;
        this.install();
    }

    public ToolExecutionResult executeCommand(String ... arguments) {
        return this.executeCommand(Collections.emptyMap(), arguments);
    }

    public ToolExecutionResult executeCommand(Map<String, String> env, String ... command) {
        logger.debug("Executing config-tool: {} on: {}", (Object)this.instanceId, (Object)this.executor.getTarget());
        return (ToolExecutionResult)this.executor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().clusterTool(this.instanceId, env, command));
    }

    public ClusterTool configure(Map<String, String> env) {
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        License license = this.tsa.getTsaConfigurationContext().getLicense();
        String clusterName = this.tsa.getTsaConfigurationContext().getClusterName();
        if (clusterName == null) {
            clusterName = this.instanceId.toString();
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("configure", "-n", clusterName));
        Topology topology = this.tsa.getTsaConfigurationContext().getTopology();
        Map<ServerSymbolicName, Integer> proxyTsaPorts = this.tsa.updateToProxiedPorts();
        logger.debug("Executing config-tool configure: {} on: {}", (Object)this.instanceId, (Object)this.executor.getTarget());
        ToolExecutionResult result = (ToolExecutionResult)this.executor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().configure(this.instanceId, topology, proxyTsaPorts, license, securityRootDirectory, tcEnv, env, command));
        if (result.getExitStatus() != 0) {
            throw new IllegalStateException("Failed to execute cluster-tool configure:\n" + result);
        }
        return this;
    }

    public ClusterTool configure() {
        return this.configure(Collections.emptyMap());
    }

    public ClusterTool install() {
        Distribution distribution = this.configContext.getDistribution();
        License license = this.tsa.getTsaConfigurationContext().getLicense();
        TerracottaCommandLineEnvironment tcEnv = this.configContext.getCommandLineEnv();
        SecurityRootDirectory securityRootDirectory = this.configContext.getSecurityRootDirectory();
        String kitInstallationPath = AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.KIT_INSTALLATION_DIR, (AngelaProperties)AngelaProperties.KIT_INSTALLATION_PATH);
        this.localKitManager.setupLocalInstall(license, kitInstallationPath, AngelaProperties.OFFLINE.getBooleanValue());
        String hostName = this.configContext.getHostName();
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        logger.info("Installing config-tool: {} on: {}", (Object)this.instanceId, (Object)this.executor.getTarget());
        IgniteCallable & Serializable callable = (IgniteCallable & Serializable)() -> AgentController.getInstance().installClusterTool(this.instanceId, hostName, distribution, license, kitInstallationName, securityRootDirectory, tcEnv, kitInstallationPath);
        boolean isRemoteInstallationSuccessful = (Boolean)this.executor.execute((IgniteCallable)callable);
        if (!(isRemoteInstallationSuccessful || kitInstallationPath != null && AngelaProperties.KIT_COPY.getBooleanValue())) {
            try {
                this.executor.uploadKit(this.instanceId, distribution, kitInstallationName, this.localKitManager.getKitInstallationPath());
                this.executor.execute((IgniteCallable)callable);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot upload kit to " + hostName, e);
            }
        }
        return this;
    }

    public ClusterTool uninstall() {
        logger.info("Uninstalling config-tool: {} on: {}", (Object)this.instanceId, (Object)this.executor.getTarget());
        Distribution distribution = this.configContext.getDistribution();
        String hostName = this.configContext.getHostName();
        String kitInstallationName = this.localKitManager.getKitInstallationName();
        IgniteRunnable & Serializable uninstaller = (IgniteRunnable & Serializable)() -> AgentController.getInstance().uninstallClusterTool(this.instanceId, distribution, hostName, kitInstallationName);
        this.executor.execute((IgniteRunnable)uninstaller);
        return this;
    }

    public RemoteFolder browse(String root) {
        logger.debug("Browsing config-tool: {} on: {}", (Object)this.instanceId, (Object)this.executor.getTarget());
        String path = (String)this.executor.execute((IgniteCallable & Serializable)() -> AgentController.getInstance().getClusterToolInstallPath(this.instanceId));
        return new RemoteFolder(this.executor, path, root);
    }

    @Override
    public void close() {
        if (!AngelaProperties.SKIP_UNINSTALL.getBooleanValue()) {
            this.uninstall();
        }
    }
}

