/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.angela.common.tcconfig.NamedSecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.topology.Version;

public class SecureTcConfig
extends TcConfig {
    private final Map<ServerSymbolicName, SecurityRootDirectory> SecurityRootDirectoryMap = new HashMap<ServerSymbolicName, SecurityRootDirectory>();

    public static SecureTcConfig secureTcConfig(Version version, URL tcConfigPath, NamedSecurityRootDirectory ... namedSecurityRootDirectories) {
        return new SecureTcConfig(version, tcConfigPath, true, namedSecurityRootDirectories);
    }

    public static SecureTcConfig secureTcConfig(Version version, URL tcConfigPath, boolean validateConfig, NamedSecurityRootDirectory ... namedSecurityRootDirectories) {
        return new SecureTcConfig(version, tcConfigPath, validateConfig, namedSecurityRootDirectories);
    }

    private SecureTcConfig(Version version, URL tcConfigPath, boolean validateConfig, NamedSecurityRootDirectory ... namedSecurityRootDirectories) {
        super(version, tcConfigPath);
        for (NamedSecurityRootDirectory namedSecurityRootDirectory : namedSecurityRootDirectories) {
            this.SecurityRootDirectoryMap.put(namedSecurityRootDirectory.getServerSymbolicName(), namedSecurityRootDirectory.getSecurityRootDirectory());
        }
        if (validateConfig) {
            this.validateConfig();
        }
    }

    private void validateConfig() {
        this.getServers().forEach(terracottaServer -> {
            ServerSymbolicName serverSymbolicName = terracottaServer.getServerSymbolicName();
            if (!this.SecurityRootDirectoryMap.containsKey(serverSymbolicName)) {
                throw new IllegalArgumentException("NamedSecurityRootDirectory is not provided for server " + serverSymbolicName.getSymbolicName());
            }
        });
        if (this.SecurityRootDirectoryMap.size() != this.getServers().size()) {
            throw new IllegalArgumentException("Given NamedSecurityRootDirectory(s) contains extra servers which are not present in tc-config, perhaps some server configurations are missing from tc-config?");
        }
    }

    public SecurityRootDirectory securityRootDirectoryFor(ServerSymbolicName serverSymbolicName) {
        return this.SecurityRootDirectoryMap.get(serverSymbolicName);
    }
}

