/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.util.Objects;
import java.util.UUID;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.util.HostPort;

public class TerracottaServer {
    private final ServerSymbolicName serverSymbolicName;
    private final String hostName;
    private final UUID id;
    private volatile int tsaPort;
    private volatile int tsaGroupPort;
    private volatile int managementPort;
    private volatile int jmxPort;
    private volatile int proxyPort;
    private volatile String bindAddress;
    private volatile String groupBindAddress;
    private volatile String configRepo;
    private volatile String configFile;
    private volatile String logs;
    private volatile String metaData;
    private volatile String dataDir;
    private volatile String offheap;
    private volatile String failoverPriority;
    private volatile String clientLeaseDuration;
    private String properties;
    private String backupDir;
    private String clientReconnectWindow;
    private String auditLogDir;
    private String securityDir;
    private String authc;
    private boolean sslTls;
    private boolean whitelist;

    private TerracottaServer(String serverSymbolicName, String hostName) {
        this.serverSymbolicName = new ServerSymbolicName(serverSymbolicName);
        this.hostName = Objects.requireNonNull(hostName);
        this.id = UUID.randomUUID();
    }

    public static TerracottaServer server(String symbolicName, String hostName) {
        return new TerracottaServer(symbolicName, hostName);
    }

    public TerracottaServer tsaPort(int tsaPort) {
        this.tsaPort = tsaPort;
        return this;
    }

    public TerracottaServer tsaGroupPort(int tsaGroupPort) {
        this.tsaGroupPort = tsaGroupPort;
        return this;
    }

    public TerracottaServer managementPort(int managementPort) {
        this.managementPort = managementPort;
        return this;
    }

    public TerracottaServer jmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
        return this;
    }

    public TerracottaServer proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public TerracottaServer bindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public TerracottaServer groupBindAddress(String groupBindAddress) {
        this.groupBindAddress = groupBindAddress;
        return this;
    }

    public TerracottaServer configRepo(String configRepo) {
        this.configRepo = configRepo;
        return this;
    }

    public TerracottaServer configFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public TerracottaServer logs(String logs) {
        this.logs = logs;
        return this;
    }

    public TerracottaServer metaData(String metaData) {
        this.metaData = metaData;
        return this;
    }

    public TerracottaServer dataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    public TerracottaServer backupDir(String backupDir) {
        this.backupDir = backupDir;
        return this;
    }

    public TerracottaServer offheap(String offheap) {
        this.offheap = offheap;
        return this;
    }

    public TerracottaServer failoverPriority(String failoverPriority) {
        this.failoverPriority = failoverPriority;
        return this;
    }

    public TerracottaServer clientLeaseDuration(String clientLeaseDuration) {
        this.clientLeaseDuration = clientLeaseDuration;
        return this;
    }

    public TerracottaServer clientReconnectWindow(String clientReconnectWindow) {
        this.clientReconnectWindow = clientReconnectWindow;
        return this;
    }

    public TerracottaServer tcProperties(String properties) {
        this.properties = properties;
        return this;
    }

    public TerracottaServer auditLogDir(String auditLogDir) {
        this.auditLogDir = auditLogDir;
        return this;
    }

    public TerracottaServer securityDir(String securityDir) {
        this.securityDir = securityDir;
        return this;
    }

    public TerracottaServer authc(String authc) {
        this.authc = authc;
        return this;
    }

    public TerracottaServer sslTls(boolean sslTls) {
        this.sslTls = sslTls;
        return this;
    }

    public TerracottaServer whitelist(boolean whitelist) {
        this.whitelist = whitelist;
        return this;
    }

    public ServerSymbolicName getServerSymbolicName() {
        return this.serverSymbolicName;
    }

    public UUID getId() {
        return this.id;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getTsaPort() {
        return this.tsaPort;
    }

    public String getHostPort() {
        return new HostPort(this.hostName, this.tsaPort).getHostPort();
    }

    public int getTsaGroupPort() {
        return this.tsaGroupPort;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getGroupBindAddress() {
        return this.groupBindAddress;
    }

    public String getConfigRepo() {
        return this.configRepo;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getOffheap() {
        return this.offheap;
    }

    public String getLogs() {
        return this.logs;
    }

    public String getFailoverPriority() {
        return this.failoverPriority;
    }

    public String getClientLeaseDuration() {
        return this.clientLeaseDuration;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public String getClientReconnectWindow() {
        return this.clientReconnectWindow;
    }

    public String getAuditLogDir() {
        return this.auditLogDir;
    }

    public String getSecurityDir() {
        return this.securityDir;
    }

    public String getAuthc() {
        return this.authc;
    }

    public boolean isSslTls() {
        return this.sslTls;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public String toString() {
        return "TerracottaServer{serverSymbolicName=" + this.serverSymbolicName + ", hostName='" + this.hostName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerracottaServer that = (TerracottaServer)o;
        return this.tsaPort == that.tsaPort && this.tsaGroupPort == that.tsaGroupPort && this.managementPort == that.managementPort && this.jmxPort == that.jmxPort && this.proxyPort == that.proxyPort && this.sslTls == that.sslTls && this.whitelist == that.whitelist && this.serverSymbolicName.equals(that.serverSymbolicName) && this.hostName.equals(that.hostName) && Objects.equals(this.id, that.id) && Objects.equals(this.bindAddress, that.bindAddress) && Objects.equals(this.groupBindAddress, that.groupBindAddress) && Objects.equals(this.configRepo, that.configRepo) && Objects.equals(this.configFile, that.configFile) && Objects.equals(this.logs, that.logs) && Objects.equals(this.metaData, that.metaData) && Objects.equals(this.dataDir, that.dataDir) && Objects.equals(this.offheap, that.offheap) && Objects.equals(this.failoverPriority, that.failoverPriority) && Objects.equals(this.clientLeaseDuration, that.clientLeaseDuration) && Objects.equals(this.properties, that.properties) && Objects.equals(this.backupDir, that.backupDir) && Objects.equals(this.clientReconnectWindow, that.clientReconnectWindow) && Objects.equals(this.auditLogDir, that.auditLogDir) && Objects.equals(this.securityDir, that.securityDir) && Objects.equals(this.authc, that.authc);
    }

    public int hashCode() {
        return Objects.hash(this.serverSymbolicName, this.hostName, this.id, this.tsaPort, this.tsaGroupPort, this.managementPort, this.jmxPort, this.proxyPort, this.bindAddress, this.groupBindAddress, this.configRepo, this.configFile, this.logs, this.metaData, this.dataDir, this.offheap, this.failoverPriority, this.clientLeaseDuration, this.properties, this.backupDir, this.clientReconnectWindow, this.auditLogDir, this.securityDir, this.authc, this.sslTls, this.whitelist);
    }
}

