/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.net.port_locking.GlobalFilePortLock;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLocker;
import org.terracotta.angela.common.net.port_locking.PortLockingException;

public class GlobalFilePortLocker
implements PortLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalFilePortLocker.class);
    private static final String TEMP_DIRECTORY_PROPERTY = "java.io.tmpdir";
    private static final String PORT_LOCK_FILENAME = "tc-port-lock";
    private static final Set<PosixFilePermission> PERMISSIONS = PosixFilePermissions.fromString("rw-rw-rw-");
    private final File portLockFile;

    public GlobalFilePortLocker() {
        String tempDirectory = System.getProperty(TEMP_DIRECTORY_PROPERTY);
        if (tempDirectory == null) {
            throw new PortLockingException("Unable to find the OS temp directory. This is platform dependent, but can be affected by system properties.");
        }
        Path path = Paths.get(tempDirectory, new String[0]);
        Path portLockFilePath = path.resolve(PORT_LOCK_FILENAME);
        try {
            this.portLockFile = GlobalFilePortLocker.createOrReuse(portLockFilePath);
        }
        catch (IOException e) {
            throw new PortLockingException("Failed to create port lock file: " + portLockFilePath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortLock tryLockPort(int port) {
        try {
            RandomAccessFile file = new RandomAccessFile(this.portLockFile, "rw");
            FileChannel channel = file.getChannel();
            FileLock fileLock = channel.tryLock(port, 1L, false);
            if (fileLock == null) {
                try {
                    channel.close();
                }
                finally {
                    file.close();
                }
                return null;
            }
            return new GlobalFilePortLock(port, file, channel, fileLock);
        }
        catch (IOException e) {
            throw new PortLockingException("Error while trying to lock port", e);
        }
    }

    private static File createOrReuse(Path portLockFilePath) throws IOException {
        File file;
        try {
            try {
                file = Files.createFile(portLockFilePath, PosixFilePermissions.asFileAttribute(PERMISSIONS)).toFile();
            }
            catch (UnsupportedOperationException e) {
                file = Files.createFile(portLockFilePath, new FileAttribute[0]).toFile();
            }
            LOGGER.info("Created port lock file: {}", (Object)file.getAbsolutePath());
        }
        catch (FileAlreadyExistsException e) {
            if (!Files.isReadable(portLockFilePath)) {
                throw new PortLockingException("File is not readable: " + portLockFilePath, e);
            }
            if (!Files.isWritable(portLockFilePath)) {
                throw new PortLockingException("File is not writable: " + portLockFilePath, e);
            }
            file = portLockFilePath.toFile();
            LOGGER.info("Using existing port lock file: {}", (Object)file.getAbsolutePath());
        }
        return file;
    }
}

