/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLocker;

public class LocalPortLocker
implements PortLocker {
    private static final Set<Integer> localPortLocks = ConcurrentHashMap.newKeySet();

    @Override
    public PortLock tryLockPort(int port) {
        boolean added = localPortLocks.add(port);
        if (!added) {
            return null;
        }
        return new LocalPortLock(port);
    }

    private static class LocalPortLock
    implements PortLock {
        private final int port;

        LocalPortLock(int port) {
            this.port = port;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void close() {
            boolean removed = localPortLocks.remove(this.port);
            if (!removed) {
                throw new AssertionError((Object)("Attempted to remove local lock on port " + this.port + " but it was not present"));
            }
        }
    }
}

