/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import org.terracotta.angela.common.net.port_locking.MuxPortLock;
import org.terracotta.angela.common.net.port_locking.PortAllocator;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLocker;

public class LockingPortChooser {
    private final PortAllocator portAllocator;
    private final PortLocker portLocker;

    public LockingPortChooser(PortAllocator portAllocator, PortLocker portLocker) {
        this.portAllocator = portAllocator;
        this.portLocker = portLocker;
    }

    public synchronized MuxPortLock choosePorts(int portCount) {
        MuxPortLock muxPortLock;
        while ((muxPortLock = this.tryChoosePorts(portCount)) == null) {
        }
        return muxPortLock;
    }

    private MuxPortLock tryChoosePorts(int portCount) {
        int portBase = this.portAllocator.allocatePorts(portCount);
        MuxPortLock muxPortLock = new MuxPortLock(portBase);
        for (int i = 0; i < portCount; ++i) {
            int port = portBase + i;
            PortLock portLock = this.portLocker.tryLockPort(port);
            if (portLock == null) {
                muxPortLock.close();
                return null;
            }
            muxPortLock.addPortLock(portLock);
        }
        return muxPortLock;
    }
}

